/*
 * rssnewsfeed.h
 *
 * Copyright (c) 2003 Frerich Raabe <raabe@kde.org>
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. For licensing and distribution details, check the
 * accompanying file 'COPYING'.
 */
#ifndef RSSNEWSFEED_H
#define RSSNEWSFEED_H

#include <tqdatetime.h>
#include <tqstringlist.h>
#include <tqvariant.h>
#include <kdatastream.h>

class QueryService;

class RSSNewsFeed
{
	friend TQDataStream &operator>>( TQDataStream &stream, RSSNewsFeed &feed );
	friend TQDataStream &operator<<( TQDataStream &stream, const RSSNewsFeed &feed );
	friend class QueryService;
	public:
		unsigned int id() const { return m_id; }
		TQString name() const { return m_name; }
		TQString description() const { return m_description; }
		TQString origin() const { return m_origin; }
		TQString languageCode() const { return m_languageCode; }
		TQString status() const { return m_status; }
		TQString version() const { return m_version; }
		TQString homePage() const { return m_homePage; }
		TQString sourceFile() const { return m_sourceFile; }
		TQString imageUrl() const { return m_imageUrl; }
		TQString webmaster() const { return m_webmaster; }
		TQString editor() const { return m_editor; }
		TQString publisher() const { return m_publisher; }
		TQString creator() const { return m_creator; }
		const TQDateTime &dateCreated() const { return m_dateCreated; }
		const TQDateTime &dateApproved() const { return m_dateApproved; }
		const TQDateTime dateXmlChanged() const { return m_dateXmlChanged; }
		bool fetchable() const { return m_fetchable; }
		unsigned int views() const { return m_views; }
		unsigned int headlinesPerDay() const { return m_headlinesPerDay; }
		unsigned int headlinesRank() const { return m_headlinesRank; }
		TQString toolkit() const { return m_toolkit; }
		TQString toolkitVersion() const { return m_toolkitVersion; }
		unsigned int pollingInterval() const { return m_pollingInterval; }
		const TQDateTime &lastPoll() const { return m_lastPoll; }
		TQStringList categories() const { return m_categories; }
	
	private:
		unsigned int m_id;
		TQString m_name;
		TQString m_description;
		TQString m_origin;
		TQString m_languageCode;
		TQString m_status;
		TQString m_version;
		TQString m_homePage;
		TQString m_sourceFile;
		TQString m_imageUrl;
		TQString m_webmaster;
		TQString m_editor;
		TQString m_publisher;
		TQString m_creator;
		TQDateTime m_dateCreated;
		TQDateTime m_dateApproved;
		TQDateTime m_dateXmlChanged;
		bool m_fetchable;
		unsigned int m_views;
		unsigned int m_headlinesPerDay;
		unsigned int m_headlinesRank;
		TQString m_toolkit;
		TQString m_toolkitVersion;
		unsigned int m_pollingInterval;
		TQDateTime m_lastPoll;
		TQStringList m_categories;
};

inline TQDataStream &operator<<( TQDataStream &stream, const RSSNewsFeed &feed )
{
	stream << feed.m_id;
	stream << feed.m_name;
	stream << feed.m_description;
	stream << feed.m_origin;
	stream << feed.m_languageCode;
	stream << feed.m_status;
	stream << feed.m_version;
	stream << feed.m_homePage;
	stream << feed.m_sourceFile;
	stream << feed.m_imageUrl;
	stream << feed.m_webmaster;
	stream << feed.m_publisher;
	stream << feed.m_creator;
	stream << feed.m_dateCreated;
	stream << feed.m_dateApproved;
	stream << feed.m_dateXmlChanged;
	stream << feed.m_fetchable;
	stream << feed.m_views;
	stream << feed.m_headlinesPerDay;
	stream << feed.m_headlinesRank;
	stream << feed.m_toolkit;
	stream << feed.m_toolkitVersion;
	stream << feed.m_pollingInterval;
	stream << feed.m_lastPoll;
	stream << feed.m_categories;

	return stream;
}

inline TQDataStream &operator>>( TQDataStream &stream, RSSNewsFeed &feed )
{
	int i;
	stream >> feed.m_id;
	stream >> feed.m_name;
	stream >> feed.m_description;
	stream >> feed.m_origin;
	stream >> feed.m_languageCode;
	stream >> feed.m_status;
	stream >> feed.m_version;
	stream >> feed.m_homePage;
	stream >> feed.m_sourceFile;
	stream >> feed.m_imageUrl;
	stream >> feed.m_webmaster;
	stream >> feed.m_publisher;
	stream >> feed.m_creator;
	stream >> feed.m_dateCreated;
	stream >> feed.m_dateApproved;
	stream >> feed.m_dateXmlChanged;
	stream >> i;
	stream >> feed.m_views;
	stream >> feed.m_headlinesPerDay;
	stream >> feed.m_headlinesRank;
	stream >> feed.m_toolkit;
	stream >> feed.m_toolkitVersion;
	stream >> feed.m_pollingInterval;
	stream >> feed.m_lastPoll;
	stream >> feed.m_categories;
	feed.m_fetchable = i != 0;
	return stream;
}

#endif
