/*
    kopeteemoticonaction.cpp

    TDEAction to show the emoticon selector

    Copyright (c) 2002      by Stefan Gehn            <metz AT gehn.net>
    Copyright (c) 2003      by Martijn Klingens       <klingens@kde.org>

    Kopete    (c) 2002-2003 by the Kopete developers  <kopete-devel@kde.org>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#include "kopeteemoticonaction.h"

#include <math.h>

#include <tqwhatsthis.h>

#include <tdeapplication.h>
#include <kdebug.h>
#include <tdelocale.h>
#include <tdemenubar.h>
#include <tdepopupmenu.h>
#include <tdetoolbar.h>
#include <tdetoolbarbutton.h>

#include "emoticonselector.h"
#include "kopeteemoticons.h"

class KopeteEmoticonAction::KopeteEmoticonActionPrivate
{
public:
	KopeteEmoticonActionPrivate()
	{
		m_delayed = true;
		m_stickyMenu = true;
		m_popup = new TDEPopupMenu(0L,"KopeteEmoticonActionPrivate::m_popup");
		emoticonSelector = new EmoticonSelector( m_popup, "KopeteEmoticonActionPrivate::emoticonSelector");
		m_popup->insertItem( emoticonSelector );
		// TODO: Maybe connect to kopeteprefs and redo list only on config changes
		connect( m_popup, TQ_SIGNAL( aboutToShow() ), emoticonSelector, TQ_SLOT( prepareList() ) );
	}

	~KopeteEmoticonActionPrivate()
	{
		delete m_popup;
		m_popup = 0;
	}

	TDEPopupMenu *m_popup;
	EmoticonSelector *emoticonSelector;
	bool m_delayed;
	bool m_stickyMenu;
};

KopeteEmoticonAction::KopeteEmoticonAction( TQObject* parent, const char* name )
  : TDEAction( i18n( "Add Smiley" ), 0, parent, name )
{
	d = new KopeteEmoticonActionPrivate;

	// Try to load the icon for our current emoticon theme, when it fails
	// fall back to our own default
	TQString icon;
	TQMap<TQString, TQStringList> emoticonsMap = Kopete::Emoticons::self()->emoticonAndPicList();
	for( TQMap<TQString, TQStringList>::const_iterator it = emoticonsMap.constBegin();
		it != emoticonsMap.constEnd(); ++it )
	{
		if( ( *it ).contains( ":)" ) || ( *it ).contains( ":-)" ) )
		{
			icon = it.key();
			break;
		}
	}

	if ( icon.isNull() )
		setIcon( "emoticon" );
	else
		setIconSet( TQIconSet( icon ) );

	setShortcutConfigurable( false );
	connect( d->emoticonSelector, TQ_SIGNAL( ItemSelected( const TQString & ) ),
		this, TQ_SIGNAL( activated( const TQString & ) ) );
}

KopeteEmoticonAction::~KopeteEmoticonAction()
{
	unplugAll();
//	kdDebug(14010) << "KopeteEmoticonAction::~KopeteEmoticonAction()" << endl;
	delete d;
	d = 0;
}

void KopeteEmoticonAction::popup( const TQPoint& global )
{
	popupMenu()->popup( global );
}

TDEPopupMenu* KopeteEmoticonAction::popupMenu() const
{
	return d->m_popup;
}

bool KopeteEmoticonAction::delayed() const
{
	return d->m_delayed;
}

void KopeteEmoticonAction::setDelayed(bool _delayed)
{
	d->m_delayed = _delayed;
}

bool KopeteEmoticonAction::stickyMenu() const
{
	return d->m_stickyMenu;
}

void KopeteEmoticonAction::setStickyMenu(bool sticky)
{
	d->m_stickyMenu = sticky;
}

int KopeteEmoticonAction::plug( TQWidget* widget, int index )
{
	if (kapp && !kapp->authorizeTDEAction(name()))
		return -1;

//	kdDebug(14010) << "KopeteEmoticonAction::plug( " << widget << ", " << index << " )" << endl;

	// KDE4/TQt TODO: Use qobject_cast instead.
	if ( widget->inherits("TQPopupMenu") )
	{
		TQPopupMenu* menu = static_cast<TQPopupMenu*>( widget );
		int id;
		if ( hasIcon() )
			id = menu->insertItem( iconSet(TDEIcon::Small), text(), d->m_popup, -1, index );
		else
			id = menu->insertItem( text(), d->m_popup, -1, index );

		if ( !isEnabled() )
			menu->setItemEnabled( id, false );

		addContainer( menu, id );
		connect( menu, TQ_SIGNAL( destroyed() ), this, TQ_SLOT( slotDestroyed() ) );

		if ( m_parentCollection )
			m_parentCollection->connectHighlight( menu, this );

		return containerCount() - 1;
	}
	// KDE4/TQt TODO: Use qobject_cast instead.
	else if ( widget->inherits( "TDEToolBar" ) )
	{
		TDEToolBar *bar = static_cast<TDEToolBar *>( widget );

		int id_ = TDEAction::getToolButtonID();

		if ( icon().isEmpty() && !iconSet(TDEIcon::Small).isNull() )
		{
			bar->insertButton(
				iconSet(TDEIcon::Small).pixmap(), id_, TQ_SIGNAL(clicked()), this,
				TQ_SLOT(slotActivated()), isEnabled(), plainText(),
				index );
		}
		else
		{
			TDEInstance *instance;

			if ( m_parentCollection )
			instance = m_parentCollection->instance();
			else
			instance = TDEGlobal::instance();

			bar->insertButton( icon(), id_, TQ_SIGNAL( clicked() ), this,
									TQ_SLOT( slotActivated() ), isEnabled(), plainText(),
									index, instance );
		}

		addContainer( bar, id_ );

		if (!whatsThis().isEmpty())
			TQWhatsThis::add( bar->getButton(id_), whatsThis() );

		connect( bar, TQ_SIGNAL( destroyed() ), this, TQ_SLOT( slotDestroyed() ) );

		if (delayed())
			bar->setDelayedPopup(id_, popupMenu(), stickyMenu());
		else
			bar->getButton(id_)->setPopup(popupMenu(), stickyMenu());

		if ( m_parentCollection )
			m_parentCollection->connectHighlight(bar, this);

		return containerCount() - 1;
	}
	// KDE4/TQt TODO: Use qobject_cast instead.
	else if ( widget->inherits( "TQMenuBar" ) )
	{
		TQMenuBar *bar = static_cast<TQMenuBar *>( widget );

		int id;

		id = bar->insertItem( text(), popupMenu(), -1, index );

		if ( !isEnabled() )
			bar->setItemEnabled( id, false );

		addContainer( bar, id );
		connect( bar, TQ_SIGNAL( destroyed() ), this, TQ_SLOT( slotDestroyed() ) );

		return containerCount() - 1;
	}

	return -1;
}

#include "kopeteemoticonaction.moc"
