/*******************************************************************
 KNotes -- Notes for the KDE project

 Copyright (c) 1997-2004, The KNotes Developers

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*******************************************************************/

#ifndef KNOTEEDIT_H
#define KNOTEEDIT_H

#include <tqwidget.h>

#include <ktextedit.h>
class KNote;
class TQFont;
class TQColor;
class TQPushButton;
class TDEAction;
class TDEActionCollection;
class TDEToggleAction;
class TDEFontAction;
class TDEFontSizeAction;


class KNoteEdit : public KTextEdit
{
    TQ_OBJECT
  
public:
    KNoteEdit( TDEActionCollection *actions, TQWidget *parent=0, const char *name=0 );
    ~KNoteEdit();
    void setNote( KNote *_note ) {
        m_note = _note;
    }
    void setText( const TQString& text );
    void setTextFont( const TQFont& font );
    void setTextColor( const TQColor& color );
    void setTabStop( int tabs );
    void setAutoIndentMode( bool newmode );

public slots:
    virtual void setTextFormat( TextFormat f );

    void textStrikeOut( bool );

    void textColor();

    void textAlignLeft();
    void textAlignCenter();
    void textAlignRight();
    void textAlignBlock();

    void textList();

    void textSuperScript();
    void textSubScript();

    //void textIncreaseIndent();
    //void textDecreaseIndent();
    void slotCutEnabled( bool );

protected:
    virtual void contentsDragEnterEvent( TQDragEnterEvent *e );
    virtual void contentsDropEvent( TQDropEvent *e );
    virtual TQPopupMenu *createPopupMenu( const TQPoint &pos );

private slots:
    void slotReturnPressed();

    void fontChanged( const TQFont &f );
    void colorChanged( const TQColor &c );
    void alignmentChanged( int a );
    void verticalAlignmentChanged( VerticalAlignment a );
    void slotAllowTab();

    void setEnabledRedo( bool b );
    void setEnabledUndo( bool b );

private:
    void autoIndent();

    virtual bool linksEnabled() const { return true; }
    virtual void emitLinkClicked( const TQString &s );

    void enableRichTextActions();
    void disableRichTextActions();

private:
    TDEAction *m_cut;
    TDEAction *m_copy;
    TDEAction *m_paste;

    TDEToggleAction *m_textBold;
    TDEToggleAction *m_textItalic;
    TDEToggleAction *m_textUnderline;
    TDEToggleAction *m_textStrikeOut;

    TDEToggleAction *m_textAlignLeft;
    TDEToggleAction *m_textAlignCenter;
    TDEToggleAction *m_textAlignRight;
    TDEToggleAction *m_textAlignBlock;

    TDEToggleAction *m_textList;
    TDEToggleAction *m_textSuper;
    TDEToggleAction *m_textSub;

    //TDEAction       *m_textIncreaseIndent;
    //TDEAction       *m_textDecreaseIndent;

    TDEAction         *m_textColor;
    TDEFontAction     *m_textFont;
    TDEFontSizeAction *m_textSize;
    TDEAction* undo;
    TDEAction* redo;
    bool m_autoIndentMode;
    KNote           *m_note;
};

#endif
