/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 2004 by Asgeir Frimannsson
                            <asgeirf@redhat.com>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

**************************************************************************** */

#ifndef KBCATALOGLISTVIEWITEM_H
#define KBCATALOGLISTVIEWITEM_H
#include <memory>
#include <tdelistview.h>
#include <tqsimplerichtext.h>
#include "mymultilineedit.h"

/**
@author 
*/
class KBCatalogListViewItem : public TDEListViewItem
{
    typedef TDEListViewItem Super;
public:
    KBCatalogListViewItem(TDEListView* lv, TDEListViewItem* parent, uint id, TQString msgid, TQString msgstr);

    ~KBCatalogListViewItem();
    
    void setMsgId(const TQString& st);
    void setMsgStr(const TQString& st);
    void setId(const uint id);
    uint getId();

protected:

    virtual void setup();
    virtual TQString key ( int column, bool ascending ) const;
    
    virtual void paintCell(TQPainter* p, const TQColorGroup& cg,
        int column, int width, int align);
        

private:
    void makeDocAvailable();
    void paintMsgIdCell(TQPainter* p, const TQColorGroup& cg,
        int column, int width, int align);
    void paintMsgStrCell(TQPainter* p, const TQColorGroup& cg,
        int column, int width, int align);
    
    TQString formatMsg(const TQString str);
    
    uint m_id;
    TQString m_msgid;
    TQString m_msgstr;
    
    std::unique_ptr<TQSimpleRichText> m_doc_msgid;
    std::unique_ptr<TQSimpleRichText> m_doc_msgstr;
};

#endif
