/***************************************************************************
                                generalsettings.h  -  description
                                -------------------
        begin                   : Sun Mar 4 2001
        copyright               : (C) 2001-2003 by Otto Bruggeman
                                  and John Firebaugh
        email                   : otto.bruggeman@home.nl
                                  jfirebaugh@kde.org
****************************************************************************/

/***************************************************************************
**
**   This program is free software; you can redistribute it and/or modify
**   it under the terms of the GNU General Public License as published by
**   the Free Software Foundation; either version 2 of the License, or
**   (at your option) any later version.
**
***************************************************************************/

#ifndef VIEWSETTINGS_H
#define VIEWSETTINGS_H

#include <tqcolor.h>
#include <tqwidget.h>

#include "difference.h"
#include "settingsbase.h"

class ViewSettings : public SettingsBase
{
TQ_OBJECT
  
public:
	static const TQColor default_removeColor;
	static const TQColor default_changeColor;
	static const TQColor default_addColor;
	static const TQColor default_appliedColor;

	ViewSettings( TQWidget* parent );
	~ViewSettings();
public:
	// some virtual functions that will be overloaded from the base class
	virtual void loadSettings( TDEConfig* config );
	virtual void saveSettings( TDEConfig* config );
	TQColor colorForDifferenceType( int type, bool selected = false, bool applied = false );

public:
	TQColor m_removeColor;
	TQColor m_changeColor;
	TQColor m_addColor;
	TQColor m_appliedColor;
	TQColor m_selectedRemoveColor;
	TQColor m_selectedChangeColor;
	TQColor m_selectedAddColor;
	TQColor m_selectedAppliedColor;
	int    m_scrollNoOfLines;
	int    m_tabToNumberOfSpaces;

	TQFont  m_font;
};

#endif // VIEWSETTINGS_H
