/**
 * qfloatinput.h
 *
 * Copyright (C)  2004  David Faure <faure@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */
#ifndef TQFLOATINPUT_H
#define TQFLOATINPUT_H

#include <tqapplication.h>
#include <tqspinbox.h>
#include <tqvalidator.h>

class TQFloatInput : public TQSpinBox
{
public:
    TQFloatInput( int min, int max, float step, int digits,
                  TQWidget *parent, const char *name = 0 );

    virtual TQString  mapValueToText( int value );

    virtual int mapTextToValue( bool* ok );

    int digits() const
    {
        return m_digits;
    }

private:
    int m_digits;
};


#endif
