/*
 * This file is part of the Polkit-tqt project
 * Copyright (C) 2009 Jaroslav Reznik <jreznik@redhat.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB. If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "polkit-tqt-listener_p.h"
#include "polkit-tqt-agent-listener.h"

#include "polkit-tqt-authority.h"
#include "polkit-tqt-subject.h"
#include "polkit-tqt-identity.h"
#include "polkit-tqt-details.h"


namespace PolkitTQt
{

namespace Agent
{

class ListenerPrivate
{
  public:
    PolkitAgentListener *listener;
    void *registeredHandle;
};

Listener::Listener(TQObject *parent) : TQObject(parent), d(new ListenerPrivate)
{
  d->listener = polkit_tqt_listener_new();

  tqDebug("New PolkitAgentListener %p", d->listener);

  ListenerAdapter::instance()->addListener(this);
}

Listener::Listener(PolkitAgentListener *listener, TQObject *parent)
        : TQObject(parent), d(new ListenerPrivate)
{
  d->listener = listener;
}

Listener::~Listener()
{
  tqDebug("Destroying listener");

  ListenerAdapter::instance()->removeListener(this);
  if (d->registeredHandle)
  {
    polkit_agent_listener_unregister(d->registeredHandle);
  }
  if (d->listener != nullptr)
  {
    g_object_unref(d->listener);
  }
}

bool Listener::registerListener(const PolkitTQt::Subject &subject, const TQString &objectPath)
{
  GError *error = nullptr;

  d->registeredHandle = polkit_agent_listener_register(d->listener,
          POLKIT_AGENT_REGISTER_FLAGS_NONE, subject.subject(), objectPath.ascii(), nullptr, &error);

  if (error != nullptr)
  {
    tqWarning(TQString("Cannot register authentication agent: %1").arg(error->message));
    g_error_free(error);
    return false;
  }

  if (d->registeredHandle == nullptr)
  {
    tqWarning(TQString("Cannot register authentication agent!"));
    return false;
  }
  return true;
}

const PolkitAgentListener *Listener::listener()
{
  return d->listener;
}

}

}

#include "polkit-tqt-agent-listener.moc"
