% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stars.R
\name{st_res}
\alias{st_res}
\title{obtain (spatial) resolution of a stars object}
\usage{
st_res(x, all = FALSE, absolute = !all)
}
\arguments{
\item{x}{an object of class \code{stars}}

\item{all}{logical; if FALSE return a vector with the x/y raster resolution}

\item{absolute}{logical; only works when \code{all = FALSE}; if TRUE return absolute resolution values, if FALSE return \code{delta} values}
}
\value{
if \code{all = FALSE} a vector with x/y raster resolutions, otherwise a list with delta values
}
\description{
obtain resolution(s) of a stars object: by default only the (absolute) x/y raster dimensions, optionally all \code{delta} dimension parameters
}
\examples{
st_res(L7_ETMs)
st_res(L7_ETMs, absolute = FALSE)
st_res(L7_ETMs, all = TRUE)
if (require(starsdata)) {
  paste0("netcdf/", c("avhrr-only-v2.19810901.nc", 
    "avhrr-only-v2.19810902.nc",
    "avhrr-only-v2.19810903.nc",
    "avhrr-only-v2.19810904.nc")) |>
  system.file(package = "starsdata") |>
  read_stars(quiet = TRUE) -> x
  st_res(x) |> print()
  st_res(x, all = TRUE) |> print()
}
}
