# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/logging/v2/logging_pb"

module Google
  module Cloud
    module Logging
      module V2
        module LoggingService
          ##
          # Client for the LoggingService service.
          #
          # Service for ingesting and querying logs.
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "logging.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :logging_service_stub

            ##
            # Configure the LoggingService Client class.
            #
            # See {::Google::Cloud::Logging::V2::LoggingService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all LoggingService clients
            #   ::Google::Cloud::Logging::V2::LoggingService::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "Logging", "V2"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config.rpcs.delete_log.timeout = 60.0
                default_config.rpcs.delete_log.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 13, 14]
                }

                default_config.rpcs.write_log_entries.timeout = 60.0
                default_config.rpcs.write_log_entries.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 13, 14]
                }

                default_config.rpcs.list_log_entries.timeout = 60.0
                default_config.rpcs.list_log_entries.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 13, 14]
                }

                default_config.rpcs.list_monitored_resource_descriptors.timeout = 60.0
                default_config.rpcs.list_monitored_resource_descriptors.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 13, 14]
                }

                default_config.rpcs.list_logs.timeout = 60.0
                default_config.rpcs.list_logs.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 13, 14]
                }

                default_config.rpcs.tail_log_entries.timeout = 3600.0
                default_config.rpcs.tail_log_entries.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 13, 14]
                }

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the LoggingService Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::Logging::V2::LoggingService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @logging_service_stub.universe_domain
            end

            ##
            # Create a new LoggingService client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::Logging::V2::LoggingService::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::Logging::V2::LoggingService::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the LoggingService client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/logging/v2/logging_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @logging_service_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::Logging::V2::LoggingServiceV2::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @logging_service_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end
            end

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @logging_service_stub.logger
            end

            # Service calls

            ##
            # Deletes all the log entries in a log for the _Default Log Bucket. The log
            # reappears if it receives new entries. Log entries written shortly before
            # the delete operation might not be deleted. Entries received after the
            # delete operation with a timestamp before the operation will be deleted.
            #
            # @overload delete_log(request, options = nil)
            #   Pass arguments to `delete_log` via a request object, either of type
            #   {::Google::Cloud::Logging::V2::DeleteLogRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Logging::V2::DeleteLogRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_log(log_name: nil)
            #   Pass arguments to `delete_log` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param log_name [::String]
            #     Required. The resource name of the log to delete:
            #
            #     * `projects/[PROJECT_ID]/logs/[LOG_ID]`
            #     * `organizations/[ORGANIZATION_ID]/logs/[LOG_ID]`
            #     * `billingAccounts/[BILLING_ACCOUNT_ID]/logs/[LOG_ID]`
            #     * `folders/[FOLDER_ID]/logs/[LOG_ID]`
            #
            #     `[LOG_ID]` must be URL-encoded. For example,
            #     `"projects/my-project-id/logs/syslog"`,
            #     `"organizations/123/logs/cloudaudit.googleapis.com%2Factivity"`.
            #
            #     For more information about log names, see
            #     {::Google::Cloud::Logging::V2::LogEntry LogEntry}.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/logging/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Logging::V2::LoggingService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Logging::V2::DeleteLogRequest.new
            #
            #   # Call the delete_log method.
            #   result = client.delete_log request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def delete_log request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Logging::V2::DeleteLogRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_log.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Logging::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.log_name
                header_params["log_name"] = request.log_name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_log.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_log.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @logging_service_stub.call_rpc :delete_log, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Writes log entries to Logging. This API method is the
            # only way to send log entries to Logging. This method
            # is used, directly or indirectly, by the Logging agent
            # (fluentd) and all logging libraries configured to use Logging.
            # A single request may contain log entries for a maximum of 1000
            # different resources (projects, organizations, billing accounts or
            # folders)
            #
            # @overload write_log_entries(request, options = nil)
            #   Pass arguments to `write_log_entries` via a request object, either of type
            #   {::Google::Cloud::Logging::V2::WriteLogEntriesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Logging::V2::WriteLogEntriesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload write_log_entries(log_name: nil, resource: nil, labels: nil, entries: nil, partial_success: nil, dry_run: nil)
            #   Pass arguments to `write_log_entries` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param log_name [::String]
            #     Optional. A default log resource name that is assigned to all log entries
            #     in `entries` that do not specify a value for `log_name`:
            #
            #     * `projects/[PROJECT_ID]/logs/[LOG_ID]`
            #     * `organizations/[ORGANIZATION_ID]/logs/[LOG_ID]`
            #     * `billingAccounts/[BILLING_ACCOUNT_ID]/logs/[LOG_ID]`
            #     * `folders/[FOLDER_ID]/logs/[LOG_ID]`
            #
            #     `[LOG_ID]` must be URL-encoded. For example:
            #
            #         "projects/my-project-id/logs/syslog"
            #         "organizations/123/logs/cloudaudit.googleapis.com%2Factivity"
            #
            #     The permission `logging.logEntries.create` is needed on each project,
            #     organization, billing account, or folder that is receiving new log
            #     entries, whether the resource is specified in `logName` or in an
            #     individual log entry.
            #   @param resource [::Google::Api::MonitoredResource, ::Hash]
            #     Optional. A default monitored resource object that is assigned to all log
            #     entries in `entries` that do not specify a value for `resource`. Example:
            #
            #         { "type": "gce_instance",
            #           "labels": {
            #             "zone": "us-central1-a", "instance_id": "00000000000000000000" }}
            #
            #     See {::Google::Cloud::Logging::V2::LogEntry LogEntry}.
            #   @param labels [::Hash{::String => ::String}]
            #     Optional. Default labels that are added to the `labels` field of all log
            #     entries in `entries`. If a log entry already has a label with the same key
            #     as a label in this parameter, then the log entry's label is not changed.
            #     See {::Google::Cloud::Logging::V2::LogEntry LogEntry}.
            #   @param entries [::Array<::Google::Cloud::Logging::V2::LogEntry, ::Hash>]
            #     Required. The log entries to send to Logging. The order of log
            #     entries in this list does not matter. Values supplied in this method's
            #     `log_name`, `resource`, and `labels` fields are copied into those log
            #     entries in this list that do not include values for their corresponding
            #     fields. For more information, see the
            #     {::Google::Cloud::Logging::V2::LogEntry LogEntry} type.
            #
            #     If the `timestamp` or `insert_id` fields are missing in log entries, then
            #     this method supplies the current time or a unique identifier, respectively.
            #     The supplied values are chosen so that, among the log entries that did not
            #     supply their own values, the entries earlier in the list will sort before
            #     the entries later in the list. See the `entries.list` method.
            #
            #     Log entries with timestamps that are more than the
            #     [logs retention period](https://cloud.google.com/logging/quotas) in
            #     the past or more than 24 hours in the future will not be available when
            #     calling `entries.list`. However, those log entries can still be [exported
            #     with
            #     LogSinks](https://cloud.google.com/logging/docs/api/tasks/exporting-logs).
            #
            #     To improve throughput and to avoid exceeding the
            #     [quota limit](https://cloud.google.com/logging/quotas) for calls to
            #     `entries.write`, you should try to include several log entries in this
            #     list, rather than calling this method for each individual log entry.
            #   @param partial_success [::Boolean]
            #     Optional. Whether a batch's valid entries should be written even if some
            #     other entry failed due to a permanent error such as INVALID_ARGUMENT or
            #     PERMISSION_DENIED. If any entry failed, then the response status is the
            #     response status of one of the failed entries. The response will include
            #     error details in `WriteLogEntriesPartialErrors.log_entry_errors` keyed by
            #     the entries' zero-based index in the `entries`. Failed requests for which
            #     no entries are written will not include per-entry errors.
            #   @param dry_run [::Boolean]
            #     Optional. If true, the request should expect normal response, but the
            #     entries won't be persisted nor exported. Useful for checking whether the
            #     logging API endpoints are working properly before sending valuable data.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Logging::V2::WriteLogEntriesResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Logging::V2::WriteLogEntriesResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/logging/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Logging::V2::LoggingService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Logging::V2::WriteLogEntriesRequest.new
            #
            #   # Call the write_log_entries method.
            #   result = client.write_log_entries request
            #
            #   # The returned object is of type Google::Cloud::Logging::V2::WriteLogEntriesResponse.
            #   p result
            #
            def write_log_entries request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Logging::V2::WriteLogEntriesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.write_log_entries.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Logging::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              options.apply_defaults timeout:      @config.rpcs.write_log_entries.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.write_log_entries.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @logging_service_stub.call_rpc :write_log_entries, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists log entries.  Use this method to retrieve log entries that originated
            # from a project/folder/organization/billing account.  For ways to export log
            # entries, see [Exporting
            # Logs](https://cloud.google.com/logging/docs/export).
            #
            # @overload list_log_entries(request, options = nil)
            #   Pass arguments to `list_log_entries` via a request object, either of type
            #   {::Google::Cloud::Logging::V2::ListLogEntriesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Logging::V2::ListLogEntriesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_log_entries(resource_names: nil, filter: nil, order_by: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_log_entries` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param resource_names [::Array<::String>]
            #     Required. Names of one or more parent resources from which to
            #     retrieve log entries:
            #
            #     *  `projects/[PROJECT_ID]`
            #     *  `organizations/[ORGANIZATION_ID]`
            #     *  `billingAccounts/[BILLING_ACCOUNT_ID]`
            #     *  `folders/[FOLDER_ID]`
            #
            #     May alternatively be one or more views:
            #
            #      * `projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW_ID]`
            #      * `organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW_ID]`
            #      * `billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW_ID]`
            #      * `folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW_ID]`
            #
            #     Projects listed in the `project_ids` field are added to this list.
            #     A maximum of 100 resources may be specified in a single request.
            #   @param filter [::String]
            #     Optional. Only log entries that match the filter are returned.  An empty
            #     filter matches all log entries in the resources listed in `resource_names`.
            #     Referencing a parent resource that is not listed in `resource_names` will
            #     cause the filter to return no results. The maximum length of a filter is
            #     20,000 characters.
            #   @param order_by [::String]
            #     Optional. How the results should be sorted.  Presently, the only permitted
            #     values are `"timestamp asc"` (default) and `"timestamp desc"`. The first
            #     option returns entries in order of increasing values of
            #     `LogEntry.timestamp` (oldest first), and the second option returns entries
            #     in order of decreasing timestamps (newest first).  Entries with equal
            #     timestamps are returned in order of their `insert_id` values.
            #   @param page_size [::Integer]
            #     Optional. The maximum number of results to return from this request.
            #     Default is 50. If the value is negative or exceeds 1000, the request is
            #     rejected. The presence of `next_page_token` in the response indicates that
            #     more results might be available.
            #   @param page_token [::String]
            #     Optional. If present, then retrieve the next batch of results from the
            #     preceding call to this method.  `page_token` must be the value of
            #     `next_page_token` from the previous response.  The values of other method
            #     parameters should be identical to those in the previous call.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Logging::V2::LogEntry>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Logging::V2::LogEntry>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/logging/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Logging::V2::LoggingService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Logging::V2::ListLogEntriesRequest.new
            #
            #   # Call the list_log_entries method.
            #   result = client.list_log_entries request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Logging::V2::LogEntry.
            #     p item
            #   end
            #
            def list_log_entries request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Logging::V2::ListLogEntriesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_log_entries.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Logging::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              options.apply_defaults timeout:      @config.rpcs.list_log_entries.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_log_entries.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @logging_service_stub.call_rpc :list_log_entries, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @logging_service_stub, :list_log_entries, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists the descriptors for monitored resource types used by Logging.
            #
            # @overload list_monitored_resource_descriptors(request, options = nil)
            #   Pass arguments to `list_monitored_resource_descriptors` via a request object, either of type
            #   {::Google::Cloud::Logging::V2::ListMonitoredResourceDescriptorsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Logging::V2::ListMonitoredResourceDescriptorsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_monitored_resource_descriptors(page_size: nil, page_token: nil)
            #   Pass arguments to `list_monitored_resource_descriptors` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param page_size [::Integer]
            #     Optional. The maximum number of results to return from this request.
            #     Non-positive values are ignored.  The presence of `nextPageToken` in the
            #     response indicates that more results might be available.
            #   @param page_token [::String]
            #     Optional. If present, then retrieve the next batch of results from the
            #     preceding call to this method.  `pageToken` must be the value of
            #     `nextPageToken` from the previous response.  The values of other method
            #     parameters should be identical to those in the previous call.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Api::MonitoredResourceDescriptor>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Api::MonitoredResourceDescriptor>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/logging/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Logging::V2::LoggingService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Logging::V2::ListMonitoredResourceDescriptorsRequest.new
            #
            #   # Call the list_monitored_resource_descriptors method.
            #   result = client.list_monitored_resource_descriptors request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Api::MonitoredResourceDescriptor.
            #     p item
            #   end
            #
            def list_monitored_resource_descriptors request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Logging::V2::ListMonitoredResourceDescriptorsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_monitored_resource_descriptors.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Logging::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              options.apply_defaults timeout:      @config.rpcs.list_monitored_resource_descriptors.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_monitored_resource_descriptors.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @logging_service_stub.call_rpc :list_monitored_resource_descriptors, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @logging_service_stub, :list_monitored_resource_descriptors, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists the logs in projects, organizations, folders, or billing accounts.
            # Only logs that have entries are listed.
            #
            # @overload list_logs(request, options = nil)
            #   Pass arguments to `list_logs` via a request object, either of type
            #   {::Google::Cloud::Logging::V2::ListLogsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Logging::V2::ListLogsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_logs(parent: nil, resource_names: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_logs` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name to list logs for:
            #
            #     *  `projects/[PROJECT_ID]`
            #     *  `organizations/[ORGANIZATION_ID]`
            #     *  `billingAccounts/[BILLING_ACCOUNT_ID]`
            #     *  `folders/[FOLDER_ID]`
            #   @param resource_names [::Array<::String>]
            #     Optional. List of resource names to list logs for:
            #
            #      * `projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW_ID]`
            #      * `organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW_ID]`
            #      * `billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW_ID]`
            #      * `folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW_ID]`
            #
            #     To support legacy queries, it could also be:
            #
            #     *  `projects/[PROJECT_ID]`
            #     *  `organizations/[ORGANIZATION_ID]`
            #     *  `billingAccounts/[BILLING_ACCOUNT_ID]`
            #     *  `folders/[FOLDER_ID]`
            #
            #     The resource name in the `parent` field is added to this list.
            #   @param page_size [::Integer]
            #     Optional. The maximum number of results to return from this request.
            #     Non-positive values are ignored.  The presence of `nextPageToken` in the
            #     response indicates that more results might be available.
            #   @param page_token [::String]
            #     Optional. If present, then retrieve the next batch of results from the
            #     preceding call to this method.  `pageToken` must be the value of
            #     `nextPageToken` from the previous response.  The values of other method
            #     parameters should be identical to those in the previous call.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Logging::V2::ListLogsResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Logging::V2::ListLogsResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/logging/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Logging::V2::LoggingService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Logging::V2::ListLogsRequest.new
            #
            #   # Call the list_logs method.
            #   result = client.list_logs request
            #
            #   # The returned object is of type Google::Cloud::Logging::V2::ListLogsResponse.
            #   p result
            #
            def list_logs request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Logging::V2::ListLogsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_logs.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Logging::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_logs.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_logs.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @logging_service_stub.call_rpc :list_logs, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Streaming read of log entries as they are ingested. Until the stream is
            # terminated, it will continue reading logs.
            #
            # @param request [::Gapic::StreamInput, ::Enumerable<::Google::Cloud::Logging::V2::TailLogEntriesRequest, ::Hash>]
            #   An enumerable of {::Google::Cloud::Logging::V2::TailLogEntriesRequest} instances.
            # @param options [::Gapic::CallOptions, ::Hash]
            #   Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Enumerable<::Google::Cloud::Logging::V2::TailLogEntriesResponse>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Enumerable<::Google::Cloud::Logging::V2::TailLogEntriesResponse>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/logging/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Logging::V2::LoggingService::Client.new
            #
            #   # Create an input stream.
            #   input = Gapic::StreamInput.new
            #
            #   # Call the tail_log_entries method to start streaming.
            #   output = client.tail_log_entries input
            #
            #   # Send requests on the stream. For each request object, set fields by
            #   # passing keyword arguments. Be sure to close the stream when done.
            #   input << Google::Cloud::Logging::V2::TailLogEntriesRequest.new
            #   input << Google::Cloud::Logging::V2::TailLogEntriesRequest.new
            #   input.close
            #
            #   # The returned object is a streamed enumerable yielding elements of type
            #   # ::Google::Cloud::Logging::V2::TailLogEntriesResponse
            #   output.each do |current_response|
            #     p current_response
            #   end
            #
            def tail_log_entries request, options = nil
              unless request.is_a? ::Enumerable
                raise ::ArgumentError, "request must be an Enumerable" unless request.respond_to? :to_enum
                request = request.to_enum
              end

              request = request.lazy.map do |req|
                ::Gapic::Protobuf.coerce req, to: ::Google::Cloud::Logging::V2::TailLogEntriesRequest
              end

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.tail_log_entries.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Logging::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              options.apply_defaults timeout:      @config.rpcs.tail_log_entries.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.tail_log_entries.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @logging_service_stub.call_rpc :tail_log_entries, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the LoggingService API.
            #
            # This class represents the configuration for LoggingService,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::Logging::V2::LoggingService::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # delete_log to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::Logging::V2::LoggingService::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.delete_log.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::Logging::V2::LoggingService::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.delete_log.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::Logging::V2::LoggingService::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "logging.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the LoggingService API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `delete_log`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_log
                ##
                # RPC-specific configuration for `write_log_entries`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :write_log_entries
                ##
                # RPC-specific configuration for `list_log_entries`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_log_entries
                ##
                # RPC-specific configuration for `list_monitored_resource_descriptors`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_monitored_resource_descriptors
                ##
                # RPC-specific configuration for `list_logs`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_logs
                ##
                # RPC-specific configuration for `tail_log_entries`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :tail_log_entries

                # @private
                def initialize parent_rpcs = nil
                  delete_log_config = parent_rpcs.delete_log if parent_rpcs.respond_to? :delete_log
                  @delete_log = ::Gapic::Config::Method.new delete_log_config
                  write_log_entries_config = parent_rpcs.write_log_entries if parent_rpcs.respond_to? :write_log_entries
                  @write_log_entries = ::Gapic::Config::Method.new write_log_entries_config
                  list_log_entries_config = parent_rpcs.list_log_entries if parent_rpcs.respond_to? :list_log_entries
                  @list_log_entries = ::Gapic::Config::Method.new list_log_entries_config
                  list_monitored_resource_descriptors_config = parent_rpcs.list_monitored_resource_descriptors if parent_rpcs.respond_to? :list_monitored_resource_descriptors
                  @list_monitored_resource_descriptors = ::Gapic::Config::Method.new list_monitored_resource_descriptors_config
                  list_logs_config = parent_rpcs.list_logs if parent_rpcs.respond_to? :list_logs
                  @list_logs = ::Gapic::Config::Method.new list_logs_config
                  tail_log_entries_config = parent_rpcs.tail_log_entries if parent_rpcs.respond_to? :tail_log_entries
                  @tail_log_entries = ::Gapic::Config::Method.new tail_log_entries_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
