%TROUNDTRIP Round trip tests for CSV.

% Licensed to the Apache Software Foundation (ASF) under one or more
% contributor license agreements.  See the NOTICE file distributed with
% this work for additional information regarding copyright ownership.
% The ASF licenses this file to you under the Apache License, Version
% 2.0 (the "License"); you may not use this file except in compliance
% with the License.  You may obtain a copy of the License at
%
%   http://www.apache.org/licenses/LICENSE-2.0
%
% Unless required by applicable law or agreed to in writing, software
% distributed under the License is distributed on an "AS IS" BASIS,
% WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
% implied.  See the License for the specific language governing
% permissions and limitations under the License.
classdef tRoundTrip < CSVTest

    properties (TestParameter)
        NumRows = { ...
            2, ...
            10, ...
            100 ...
        }
        WithNulls = { ...
            true, ...
            false ...
        }
        ColumnNames = {...
            ["A", "B", "C"], ...
            ["😀", "🌲", "🥭", " ", "ABC"], ...
            [" ", " ", " "]
        }
    end

    methods(Test)

        function Numeric(testCase, NumRows, WithNulls, ColumnNames)
            arrowTable = testCase.makeArrowTable(...
                Type="numeric", ...
                NumRows=NumRows, ...
                WithNulls=WithNulls, ...
                ColumnNames=ColumnNames ...
            );

            testCase.verifyRoundTrip(arrowTable);
        end

        function String(testCase, NumRows, ColumnNames)
            arrowTable = testCase.makeArrowTable(...
                Type="string", ...
                NumRows=NumRows, ...
                WithNulls=false, ...
                ColumnNames=ColumnNames ...
            );

            testCase.verifyRoundTrip(arrowTable);
        end

    end

end