/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.settings;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.config.DurationSpec;
import org.apache.cassandra.stress.settings.GroupedOptions;
import org.apache.cassandra.stress.settings.Option;
import org.apache.cassandra.stress.settings.OptionSimple;
import org.apache.cassandra.stress.util.ResultLogger;

public class SettingsReporting
implements Serializable {
    public final int outputFrequency;
    private final String outputFrequencyString;
    public final int headerFrequency;
    private final String headerFrequencyString;

    public SettingsReporting(Options reporting) {
        if (reporting.headerFrequency.present()) {
            this.headerFrequencyString = reporting.headerFrequency.value();
            this.headerFrequency = new DurationSpec.IntSecondsBound(this.headerFrequencyString).toSeconds();
        } else {
            this.headerFrequency = 0;
            this.headerFrequencyString = "*not set*";
        }
        if (reporting.outputFrequency.present()) {
            this.outputFrequencyString = reporting.outputFrequency.value();
            this.outputFrequency = new DurationSpec.IntSecondsBound(this.outputFrequencyString).toSeconds();
        } else {
            this.outputFrequency = 0;
            this.outputFrequencyString = "*not set*";
        }
    }

    public static SettingsReporting get(Map<String, String[]> clArgs) {
        String[] params = clArgs.remove("-reporting");
        if (params == null) {
            return new SettingsReporting(new Options());
        }
        GroupedOptions options = GroupedOptions.select((String[])params, (GroupedOptions[])new Options[]{new Options()});
        if (options == null) {
            SettingsReporting.printHelp();
            System.out.println("Invalid -reporting options provided, see output for valid options");
            System.exit(1);
        }
        return new SettingsReporting((Options)options);
    }

    public void printSettings(ResultLogger out) {
        out.printf("  Output frequency: %s%n", this.outputFrequencyString);
        out.printf("  Header frequency: %s%n", this.headerFrequencyString);
    }

    public static void printHelp() {
        GroupedOptions.printOptions(System.out, "-reporting", new Options());
    }

    public static Runnable helpPrinter() {
        return SettingsReporting::printHelp;
    }

    public static final class Options
    extends GroupedOptions {
        final OptionSimple outputFrequency = new OptionSimple("output-frequency=", ".*", "1s", "Frequency each line of output will be printed out when running a stress test, defaults to '1s'.", false);
        final OptionSimple headerFrequency = new OptionSimple("header-frequency=", ".*", null, "Frequency the header for the statistics will be printed out. If not specified, the header will be printed at the beginning of the test only.", false);

        @Override
        public List<? extends Option> options() {
            return Arrays.asList(this.outputFrequency, this.headerFrequency);
        }
    }
}

