/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.QualifiedName;
import org.apache.cassandra.service.ClientState;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public abstract class QualifiedStatement
extends CQLStatement.Raw {
    final QualifiedName qualifiedName;

    QualifiedStatement(QualifiedName qualifiedName) {
        this.qualifiedName = qualifiedName;
    }

    public boolean isFullyQualified() {
        return this.qualifiedName.hasKeyspace();
    }

    public void setKeyspace(ClientState state) {
        if (!this.qualifiedName.hasKeyspace()) {
            this.qualifiedName.setKeyspace(state.getKeyspace(), true);
        }
    }

    public void setKeyspace(String keyspace) {
        this.qualifiedName.setKeyspace(keyspace, true);
    }

    public String keyspace() {
        if (!this.qualifiedName.hasKeyspace()) {
            throw new IllegalStateException("Statement must have keyspace set");
        }
        return this.qualifiedName.getKeyspace();
    }

    public String name() {
        return this.qualifiedName.getName();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

