/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.analytics;

import java.util.concurrent.TimeUnit;
import org.apache.cassandra.analytics.DataGenerationUtils;
import org.apache.cassandra.analytics.SharedClusterSparkIntegrationTestBase;
import org.apache.cassandra.distributed.api.ConsistencyLevel;
import org.apache.cassandra.distributed.api.SimpleQueryResult;
import org.apache.cassandra.distributed.shared.Uninterruptibles;
import org.apache.cassandra.sidecar.testing.QualifiedName;
import org.apache.cassandra.spark.bulkwriter.TTLOption;
import org.apache.cassandra.spark.bulkwriter.WriterOptions;
import org.apache.cassandra.testing.ClusterBuilderConfiguration;
import org.apache.cassandra.testing.TestUtils;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class BulkWriteTtlTest
extends SharedClusterSparkIntegrationTestBase {
    static final QualifiedName DEFAULT_TTL_NAME = new QualifiedName("spark_test", "test_default_ttl");
    static final QualifiedName CONSTANT_TTL_NAME = new QualifiedName("spark_test", "test_ttl_constant");
    static final QualifiedName PER_ROW_TTL_NAME = new QualifiedName("spark_test", "test_ttl_per_row");

    BulkWriteTtlTest() {
    }

    @Test
    void testTableDefaultTtl() {
        SparkSession spark = this.getOrCreateSparkSession();
        Dataset<Row> df = DataGenerationUtils.generateCourseData(spark, 1000);
        this.bulkWriterDataFrameWriter(df, DEFAULT_TTL_NAME).save();
        Uninterruptibles.sleepUninterruptibly((long)1100L, (TimeUnit)TimeUnit.MILLISECONDS);
        SimpleQueryResult result = this.cluster.coordinator(1).executeWithResult("SELECT * FROM " + String.valueOf(DEFAULT_TTL_NAME), ConsistencyLevel.ALL, new Object[0]);
        Assertions.assertThat((boolean)result.hasNext()).isFalse();
    }

    @Test
    void testTtlOptionConstant() {
        SparkSession spark = this.getOrCreateSparkSession();
        Dataset<Row> df = DataGenerationUtils.generateCourseData(spark, 1000);
        this.bulkWriterDataFrameWriter(df, CONSTANT_TTL_NAME).option(WriterOptions.TTL.name(), TTLOption.constant((int)1)).save();
        Uninterruptibles.sleepUninterruptibly((long)1100L, (TimeUnit)TimeUnit.MILLISECONDS);
        SimpleQueryResult result = this.cluster.coordinator(1).executeWithResult("SELECT * FROM " + String.valueOf(CONSTANT_TTL_NAME), ConsistencyLevel.ALL, new Object[0]);
        Assertions.assertThat((boolean)result.hasNext()).isFalse();
    }

    @Test
    void testTtlOptionPerRow() {
        SparkSession spark = this.getOrCreateSparkSession();
        Dataset<Row> df = DataGenerationUtils.generateCourseData(spark, 1, null, 1000);
        this.bulkWriterDataFrameWriter(df, PER_ROW_TTL_NAME).option(WriterOptions.TTL.name(), TTLOption.perRow((String)"ttl")).save();
        Uninterruptibles.sleepUninterruptibly((long)1100L, (TimeUnit)TimeUnit.MILLISECONDS);
        SimpleQueryResult result = this.cluster.coordinator(1).executeWithResult("SELECT * FROM " + String.valueOf(PER_ROW_TTL_NAME), ConsistencyLevel.ALL, new Object[0]);
        Assertions.assertThat((boolean)result.hasNext()).isFalse();
    }

    protected ClusterBuilderConfiguration testClusterConfiguration() {
        return super.testClusterConfiguration().nodesPerDc(3);
    }

    protected void initializeSchemaForTest() {
        this.createTestKeyspace(DEFAULT_TTL_NAME, TestUtils.DC1_RF3);
        this.cluster.schemaChangeIgnoringStoppedInstances("CREATE TABLE " + String.valueOf(DEFAULT_TTL_NAME) + " (\n          id BIGINT PRIMARY KEY,\n          course TEXT,\n          marks BIGINT\n     )  WITH default_time_to_live = 1;");
        this.cluster.schemaChangeIgnoringStoppedInstances("CREATE TABLE " + String.valueOf(CONSTANT_TTL_NAME) + " (\n          id BIGINT PRIMARY KEY,\n          course TEXT,\n          marks BIGINT\n     );");
        this.cluster.schemaChangeIgnoringStoppedInstances("CREATE TABLE " + String.valueOf(PER_ROW_TTL_NAME) + " (\n          id BIGINT PRIMARY KEY,\n          course TEXT,\n          marks BIGINT\n     );");
    }
}

