/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter.util;

import com.google.common.primitives.UnsignedLongs;
import java.lang.reflect.Field;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.AccessController;
import sun.misc.Unsafe;

public final class FastByteOperations {
    private FastByteOperations() {
        throw new IllegalStateException(String.valueOf(this.getClass()) + " is static utility class and shall not be instantiated");
    }

    public static int compareUnsigned(ByteBuffer buffer1, ByteBuffer buffer2) {
        return BestHolder.BEST.compare(buffer1, buffer2);
    }

    public static final class PureJavaOperations
    implements ByteOperations {
        @Override
        public int compare(ByteBuffer buffer1, ByteBuffer buffer2) {
            int end1 = buffer1.limit();
            int end2 = buffer2.limit();
            int index1 = buffer1.position();
            for (int index2 = buffer2.position(); index1 < end1 && index2 < end2; ++index1, ++index2) {
                int byte2;
                int byte1 = buffer1.get(index1) & 0xFF;
                if (byte1 == (byte2 = buffer2.get(index2) & 0xFF)) continue;
                return byte1 - byte2;
            }
            return buffer1.remaining() - buffer2.remaining();
        }
    }

    public static final class UnsafeOperations
    implements ByteOperations {
        static final Unsafe UNSAFE = (Unsafe)AccessController.doPrivileged(() -> {
            try {
                Field field = Unsafe.class.getDeclaredField("UNSAFE");
                field.setAccessible(true);
                return field.get(null);
            }
            catch (IllegalAccessException | NoSuchFieldException exception) {
                throw new Error();
            }
        });
        static final long BYTE_ARRAY_BASE_OFFSET;
        static final long DIRECT_BUFFER_ADDRESS_OFFSET;
        static final boolean BIG_ENDIAN;

        @Override
        public int compare(ByteBuffer buffer1, ByteBuffer buffer2) {
            return UnsafeOperations.compareTo(buffer1, buffer2);
        }

        static int compareTo(ByteBuffer buffer1, ByteBuffer buffer2) {
            long offset1;
            byte[] object1;
            if (buffer1.hasArray()) {
                object1 = buffer1.array();
                offset1 = BYTE_ARRAY_BASE_OFFSET + (long)buffer1.arrayOffset();
            } else {
                object1 = null;
                offset1 = UNSAFE.getLong(buffer1, DIRECT_BUFFER_ADDRESS_OFFSET);
            }
            int length1 = buffer1.remaining();
            return UnsafeOperations.compareTo(object1, offset1 += (long)buffer1.position(), length1, buffer2);
        }

        static int compareTo(Object buffer1, long offset1, int length1, ByteBuffer buffer2) {
            long offset2;
            byte[] object2;
            int position = buffer2.position();
            int limit = buffer2.limit();
            if (buffer2.hasArray()) {
                object2 = buffer2.array();
                offset2 = BYTE_ARRAY_BASE_OFFSET + (long)buffer2.arrayOffset();
            } else {
                object2 = null;
                offset2 = UNSAFE.getLong(buffer2, DIRECT_BUFFER_ADDRESS_OFFSET);
            }
            int length2 = limit - position;
            return UnsafeOperations.compareTo(buffer1, offset1, length1, object2, offset2 += (long)position, length2);
        }

        static int compareTo(Object buffer1, long offset1, int length1, Object buffer2, long offset2, int length2) {
            int index;
            int minLength = Math.min(length1, length2);
            int wordComparisons = minLength & 0xFFFFFFF8;
            for (index = 0; index < wordComparisons; index += 8) {
                long long2;
                long long1 = UNSAFE.getLong(buffer1, offset1 + (long)index);
                if (long1 == (long2 = UNSAFE.getLong(buffer2, offset2 + (long)index))) continue;
                return BIG_ENDIAN ? UnsignedLongs.compare((long)long1, (long)long2) : UnsignedLongs.compare((long)Long.reverseBytes(long1), (long)Long.reverseBytes(long2));
            }
            for (index = wordComparisons; index < minLength; ++index) {
                int byte2;
                int byte1 = UNSAFE.getByte(buffer1, offset1 + (long)index) & 0xFF;
                if (byte1 == (byte2 = UNSAFE.getByte(buffer2, offset2 + (long)index) & 0xFF)) continue;
                return byte1 - byte2;
            }
            return length1 - length2;
        }

        static {
            try {
                BYTE_ARRAY_BASE_OFFSET = UNSAFE.arrayBaseOffset(byte[].class);
                DIRECT_BUFFER_ADDRESS_OFFSET = UNSAFE.objectFieldOffset(Buffer.class.getDeclaredField("address"));
            }
            catch (Exception exception) {
                throw new AssertionError((Object)exception);
            }
            if (UNSAFE.arrayIndexScale(byte[].class) != 1) {
                throw new AssertionError();
            }
            BIG_ENDIAN = ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN);
        }
    }

    private static class BestHolder {
        static final String UNSAFE_COMPARER_NAME = FastByteOperations.class.getName() + "$UnsafeOperations";
        static final ByteOperations BEST = BestHolder.getBest();

        private BestHolder() {
        }

        static ByteOperations getBest() {
            boolean unaligned;
            String arch = System.getProperty("os.arch");
            boolean bl = unaligned = arch.equals("i386") || arch.equals("x86") || arch.equals("x86_64") || arch.equals("amd64");
            if (!unaligned) {
                return new PureJavaOperations();
            }
            try {
                Class<?> theClass = Class.forName(UNSAFE_COMPARER_NAME);
                ByteOperations comparer = (ByteOperations)theClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                return comparer;
            }
            catch (Throwable throwable) {
                return new PureJavaOperations();
            }
        }
    }

    public static interface ByteOperations {
        public int compare(ByteBuffer var1, ByteBuffer var2);
    }
}

