/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.util.HashSet;
import org.apache.cassandra.db.CassandraWriteContext;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.KeyspaceWriteHandler;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.WriteContext;
import org.apache.cassandra.db.commitlog.CommitLog;
import org.apache.cassandra.db.commitlog.CommitLogPosition;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.schema.TableId;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.concurrent.OpOrder;

public class CassandraKeyspaceWriteHandler
implements KeyspaceWriteHandler {
    private final Keyspace keyspace;

    public CassandraKeyspaceWriteHandler(Keyspace keyspace) {
        this.keyspace = keyspace;
    }

    @Override
    public WriteContext beginWrite(Mutation mutation, boolean makeDurable) throws RequestExecutionException {
        OpOrder.Group group = null;
        try {
            group = Keyspace.writeOrder.start();
            CommitLogPosition position = null;
            if (makeDurable) {
                position = this.addToCommitLog(mutation);
            }
            return new CassandraWriteContext(group, position);
        }
        catch (Throwable t2) {
            if (group != null) {
                group.close();
            }
            throw t2;
        }
    }

    private CommitLogPosition addToCommitLog(Mutation mutation) {
        boolean allSkipCommitlog = true;
        boolean noneSkipCommitlog = true;
        for (PartitionUpdate update : mutation.getPartitionUpdates()) {
            if (update.metadata().params.memtable.factory().writesShouldSkipCommitLog()) {
                noneSkipCommitlog = false;
                continue;
            }
            allSkipCommitlog = false;
        }
        if (!noneSkipCommitlog) {
            if (allSkipCommitlog) {
                return null;
            }
            HashSet<TableId> ids = new HashSet<TableId>();
            for (PartitionUpdate update : mutation.getPartitionUpdates()) {
                if (!update.metadata().params.memtable.factory().writesShouldSkipCommitLog()) continue;
                ids.add(update.metadata().id);
            }
            mutation = mutation.without(ids);
        }
        Tracing.trace("Appending to commitlog");
        return CommitLog.instance.add(mutation);
    }

    private WriteContext createEmptyContext() {
        OpOrder.Group group = null;
        try {
            group = Keyspace.writeOrder.start();
            return new CassandraWriteContext(group, null);
        }
        catch (Throwable t2) {
            if (group != null) {
                group.close();
            }
            throw t2;
        }
    }

    @Override
    public WriteContext createContextForIndexing() {
        return this.createEmptyContext();
    }

    @Override
    public WriteContext createContextForRead() {
        return this.createEmptyContext();
    }
}

