/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.rows;

import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.RegularAndStaticColumns;
import org.apache.cassandra.db.rows.EncodingStats;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.utils.AbstractIterator;

public abstract class LazilyInitializedUnfilteredRowIterator
extends AbstractIterator<Unfiltered>
implements UnfilteredRowIterator {
    private final DecoratedKey partitionKey;
    private UnfilteredRowIterator iterator;

    public LazilyInitializedUnfilteredRowIterator(DecoratedKey partitionKey) {
        this.partitionKey = partitionKey;
    }

    protected abstract UnfilteredRowIterator initializeIterator();

    protected void maybeInit() {
        if (this.iterator == null) {
            this.iterator = this.initializeIterator();
        }
    }

    @Override
    public TableMetadata metadata() {
        this.maybeInit();
        return this.iterator.metadata();
    }

    @Override
    public RegularAndStaticColumns columns() {
        this.maybeInit();
        return this.iterator.columns();
    }

    @Override
    public boolean isReverseOrder() {
        this.maybeInit();
        return this.iterator.isReverseOrder();
    }

    @Override
    public DecoratedKey partitionKey() {
        return this.partitionKey;
    }

    @Override
    public DeletionTime partitionLevelDeletion() {
        this.maybeInit();
        return this.iterator.partitionLevelDeletion();
    }

    @Override
    public Row staticRow() {
        this.maybeInit();
        return this.iterator.staticRow();
    }

    @Override
    public EncodingStats stats() {
        this.maybeInit();
        return this.iterator.stats();
    }

    @Override
    protected Unfiltered computeNext() {
        this.maybeInit();
        return this.iterator.hasNext() ? (Unfiltered)this.iterator.next() : (Unfiltered)this.endOfData();
    }

    @Override
    public void close() {
        if (this.iterator != null) {
            this.iterator.close();
            this.iterator = null;
        }
    }

    public boolean isOpen() {
        return this.iterator != null;
    }
}

