/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair.consistent.admin;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import org.apache.cassandra.repair.consistent.admin.PendingStat;
import org.apache.cassandra.repair.consistent.admin.RepairStats;

public class PendingStats {
    private static final String[] COMPOSITE_NAMES = new String[]{"keyspace", "table", "total", "pending", "finalized", "failed"};
    private static final OpenType<?>[] COMPOSITE_TYPES;
    private static final CompositeType COMPOSITE_TYPE;
    public final String keyspace;
    public final String table;
    public final PendingStat total;
    public final PendingStat pending;
    public final PendingStat finalized;
    public final PendingStat failed;

    public PendingStats(String keyspace, String table, PendingStat pending, PendingStat finalized, PendingStat failed) {
        this.keyspace = keyspace;
        this.table = table;
        this.total = new PendingStat.Builder().addStat(pending).addStat(finalized).addStat(failed).build();
        this.pending = pending;
        this.finalized = finalized;
        this.failed = failed;
    }

    public CompositeData toComposite() {
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put(COMPOSITE_NAMES[0], this.keyspace);
        values.put(COMPOSITE_NAMES[1], this.table);
        values.put(COMPOSITE_NAMES[2], this.total.toComposite());
        values.put(COMPOSITE_NAMES[3], this.pending.toComposite());
        values.put(COMPOSITE_NAMES[4], this.finalized.toComposite());
        values.put(COMPOSITE_NAMES[5], this.failed.toComposite());
        try {
            return new CompositeDataSupport(COMPOSITE_TYPE, values);
        }
        catch (OpenDataException e) {
            throw new RuntimeException(e);
        }
    }

    public static PendingStats fromComposite(CompositeData cd2) {
        Preconditions.checkArgument(cd2.getCompositeType().equals(COMPOSITE_TYPE));
        Object[] values = cd2.getAll(COMPOSITE_NAMES);
        return new PendingStats((String)values[0], (String)values[1], PendingStat.fromComposite((CompositeData)values[2]), PendingStat.fromComposite((CompositeData)values[3]), PendingStat.fromComposite((CompositeData)values[3]));
    }

    static {
        try {
            COMPOSITE_TYPES = new OpenType[]{SimpleType.STRING, SimpleType.STRING, PendingStat.COMPOSITE_TYPE, PendingStat.COMPOSITE_TYPE, PendingStat.COMPOSITE_TYPE, PendingStat.COMPOSITE_TYPE};
            COMPOSITE_TYPE = new CompositeType(RepairStats.Section.class.getName(), "PendingStats", COMPOSITE_NAMES, COMPOSITE_NAMES, COMPOSITE_TYPES);
        }
        catch (OpenDataException e) {
            throw new RuntimeException(e);
        }
    }
}

