/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarCacheObject;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarLog;
import org.hyperic.sigar.SigarNotImplementedException;
import org.hyperic.sigar.SigarPermissionDeniedException;
import org.hyperic.sigar.SigarProxy;
import org.hyperic.sigar.util.ReferenceMap;

public class SigarProxyCache
implements InvocationHandler {
    private Sigar sigar;
    private Map cache = ReferenceMap.newInstance();
    public static final int EXPIRE_DEFAULT = 30000;
    private int expire;
    private static final boolean debugEnabled = "debug".equals(System.getProperty("sigar.log"));

    public SigarProxyCache(Sigar sigar, int expire) {
        this.sigar = sigar;
        this.expire = expire;
    }

    public static SigarProxy newInstance() {
        return SigarProxyCache.newInstance(new Sigar());
    }

    public static SigarProxy newInstance(Sigar sigar) {
        return SigarProxyCache.newInstance(sigar, 30000);
    }

    public static SigarProxy newInstance(Sigar sigar, int expire) {
        SigarProxyCache handler = new SigarProxyCache(sigar, expire);
        SigarProxy proxy = (SigarProxy)Proxy.newProxyInstance(SigarProxy.class.getClassLoader(), new Class[]{SigarProxy.class}, (InvocationHandler)handler);
        return proxy;
    }

    private void debug(String msg) {
        SigarLog.getLogger("SigarProxyCache").debug(msg);
    }

    public static void setExpire(SigarProxy proxy, String type, int expire) throws SigarException {
    }

    private static SigarProxyCache getHandler(Object proxy) {
        return (SigarProxyCache)Proxy.getInvocationHandler(proxy);
    }

    public static void clear(Object proxy) {
        SigarProxyCache.getHandler((Object)proxy).cache.clear();
    }

    public static Sigar getSigar(Object proxy) {
        if (proxy.getClass() == Sigar.class) {
            return (Sigar)proxy;
        }
        return SigarProxyCache.getHandler((Object)proxy).sigar;
    }

    private String getDebugArgs(Object[] args, Object argKey) {
        if (args.length == 0) {
            return null;
        }
        StringBuffer dargs = new StringBuffer(args[0].toString());
        for (int i = 1; i < args.length; ++i) {
            dargs.append(',').append(args[i].toString());
        }
        if (!dargs.toString().equals(argKey.toString())) {
            dargs.append('/').append(argKey);
        }
        return dargs.toString();
    }

    public synchronized Object invoke(Object proxy, Method method, Object[] args) throws SigarException, SigarNotImplementedException {
        Object retval;
        SigarCacheObject cacheVal = null;
        Object argKey = null;
        Map argMap = null;
        long timeNow = System.currentTimeMillis();
        if (args != null) {
            if (args.length == 1) {
                argKey = args[0];
            } else {
                int hashCode = 0;
                for (int i = 0; i < args.length; ++i) {
                    hashCode ^= args[i].hashCode();
                }
                argKey = new Integer(hashCode);
            }
            argMap = (Map)this.cache.get(method);
            if (argMap == null) {
                argMap = ReferenceMap.newInstance();
            } else {
                cacheVal = (SigarCacheObject)argMap.get(argKey);
            }
        } else {
            cacheVal = (SigarCacheObject)this.cache.get(method);
        }
        if (cacheVal == null) {
            cacheVal = new SigarCacheObject();
        }
        String argDebug = "";
        if (debugEnabled && args != null && args.length != 0) {
            argDebug = " with args=" + this.getDebugArgs(args, argKey);
        }
        if (cacheVal.value != null) {
            if (debugEnabled) {
                this.debug("found " + method.getName() + " in cache" + argDebug);
            }
            if (timeNow - cacheVal.timestamp > (long)this.expire) {
                if (debugEnabled) {
                    this.debug("expiring " + method.getName() + " from cache" + argDebug);
                }
                cacheVal.value = null;
            }
        } else if (debugEnabled) {
            this.debug(method.getName() + " NOT in cache" + argDebug);
        }
        if (cacheVal.value == null) {
            try {
                retval = method.invoke((Object)this.sigar, args);
            }
            catch (InvocationTargetException e) {
                Throwable t2 = e.getTargetException();
                String msg = t2 instanceof SigarException ? "" : t2.getClass().getName() + ": ";
                msg = msg + t2.getMessage();
                if (argKey != null) {
                    msg = msg + ": " + this.getDebugArgs(args, argKey);
                }
                if (t2 instanceof SigarNotImplementedException) {
                    throw new SigarNotImplementedException(msg);
                }
                if (t2 instanceof SigarPermissionDeniedException) {
                    throw new SigarPermissionDeniedException(msg);
                }
                throw new SigarException(msg);
            }
            catch (Exception e) {
                String msg = e.getClass().getName() + ": " + e.getMessage();
                if (argKey != null) {
                    msg = msg + ": " + this.getDebugArgs(args, argKey);
                }
                throw new SigarException(msg);
            }
            cacheVal.value = retval;
            cacheVal.timestamp = timeNow;
            if (args == null) {
                this.cache.put(method, cacheVal);
            } else {
                argMap.put(argKey, cacheVal);
                this.cache.put(method, argMap);
            }
        } else {
            retval = cacheVal.value;
        }
        return retval;
    }
}

