/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.format;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.RowIndexEntry;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.db.lifecycle.LifecycleNewTracker;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.index.Index;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.format.SSTableFlushObserver;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.metadata.MetadataCollector;
import org.apache.cassandra.io.sstable.metadata.MetadataComponent;
import org.apache.cassandra.io.sstable.metadata.MetadataType;
import org.apache.cassandra.io.sstable.metadata.StatsMetadata;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.schema.Schema;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.schema.TableMetadataRef;
import org.apache.cassandra.utils.concurrent.Transactional;

public abstract class SSTableWriter
extends SSTable
implements Transactional {
    protected long repairedAt;
    protected UUID pendingRepair;
    protected boolean isTransient;
    protected long maxDataAge = -1L;
    protected final long keyCount;
    protected final MetadataCollector metadataCollector;
    protected final RowIndexEntry.IndexSerializer rowIndexEntrySerializer;
    protected final SerializationHeader header;
    protected final TransactionalProxy txnProxy = this.txnProxy();
    protected final Collection<SSTableFlushObserver> observers;

    protected abstract TransactionalProxy txnProxy();

    protected SSTableWriter(Descriptor descriptor, long keyCount, long repairedAt, UUID pendingRepair, boolean isTransient, TableMetadataRef metadata, MetadataCollector metadataCollector, SerializationHeader header, Collection<SSTableFlushObserver> observers) {
        super(descriptor, SSTableWriter.components(metadata.getLocal()), metadata, DatabaseDescriptor.getDiskOptimizationStrategy());
        this.keyCount = keyCount;
        this.repairedAt = repairedAt;
        this.pendingRepair = pendingRepair;
        this.isTransient = isTransient;
        this.metadataCollector = metadataCollector;
        this.header = header;
        this.rowIndexEntrySerializer = descriptor.version.getSSTableFormat().getIndexSerializer(metadata.get(), descriptor.version, header);
        this.observers = observers == null ? Collections.emptySet() : observers;
    }

    public static SSTableWriter create(Descriptor descriptor, Long keyCount, Long repairedAt, UUID pendingRepair, boolean isTransient, TableMetadataRef metadata, MetadataCollector metadataCollector, SerializationHeader header, Collection<Index> indexes, LifecycleNewTracker lifecycleNewTracker) {
        Factory writerFactory = descriptor.getFormat().getWriterFactory();
        return writerFactory.open(descriptor, keyCount, repairedAt, pendingRepair, isTransient, metadata, metadataCollector, header, SSTableWriter.observers(descriptor, indexes, lifecycleNewTracker.opType()), lifecycleNewTracker);
    }

    public static SSTableWriter create(Descriptor descriptor, long keyCount, long repairedAt, UUID pendingRepair, boolean isTransient, int sstableLevel, SerializationHeader header, Collection<Index> indexes, LifecycleNewTracker lifecycleNewTracker) {
        TableMetadataRef metadata = Schema.instance.getTableMetadataRef(descriptor);
        return SSTableWriter.create(metadata, descriptor, keyCount, repairedAt, pendingRepair, isTransient, sstableLevel, header, indexes, lifecycleNewTracker);
    }

    public static SSTableWriter create(TableMetadataRef metadata, Descriptor descriptor, long keyCount, long repairedAt, UUID pendingRepair, boolean isTransient, int sstableLevel, SerializationHeader header, Collection<Index> indexes, LifecycleNewTracker lifecycleNewTracker) {
        MetadataCollector collector = new MetadataCollector(metadata.get().comparator).sstableLevel(sstableLevel);
        return SSTableWriter.create(descriptor, keyCount, (Long)repairedAt, pendingRepair, isTransient, metadata, collector, header, indexes, lifecycleNewTracker);
    }

    @VisibleForTesting
    public static SSTableWriter create(Descriptor descriptor, long keyCount, long repairedAt, UUID pendingRepair, boolean isTransient, SerializationHeader header, Collection<Index> indexes, LifecycleNewTracker lifecycleNewTracker) {
        return SSTableWriter.create(descriptor, keyCount, repairedAt, pendingRepair, isTransient, 0, header, indexes, lifecycleNewTracker);
    }

    private static Set<Component> components(TableMetadata metadata) {
        HashSet<Component> components = new HashSet<Component>(Arrays.asList(Component.DATA, Component.PRIMARY_INDEX, Component.STATS, Component.SUMMARY, Component.TOC, Component.DIGEST));
        if (metadata.params.bloomFilterFpChance < 1.0) {
            components.add(Component.FILTER);
        }
        if (metadata.params.compression.isEnabled()) {
            components.add(Component.COMPRESSION_INFO);
        } else {
            components.add(Component.CRC);
        }
        return components;
    }

    private static Collection<SSTableFlushObserver> observers(Descriptor descriptor, Collection<Index> indexes, OperationType operationType) {
        if (indexes == null) {
            return Collections.emptyList();
        }
        ArrayList<SSTableFlushObserver> observers = new ArrayList<SSTableFlushObserver>(indexes.size());
        for (Index index : indexes) {
            SSTableFlushObserver observer = index.getFlushObserver(descriptor, operationType);
            if (observer == null) continue;
            observer.begin();
            observers.add(observer);
        }
        return ImmutableList.copyOf(observers);
    }

    public abstract void mark();

    public abstract RowIndexEntry append(UnfilteredRowIterator var1);

    public abstract long getFilePointer();

    public abstract long getOnDiskFilePointer();

    public long getEstimatedOnDiskBytesWritten() {
        return this.getOnDiskFilePointer();
    }

    public abstract void resetAndTruncate();

    public SSTableWriter setRepairedAt(long repairedAt) {
        if (repairedAt > 0L) {
            this.repairedAt = repairedAt;
        }
        return this;
    }

    public SSTableWriter setMaxDataAge(long maxDataAge) {
        this.maxDataAge = maxDataAge;
        return this;
    }

    public SSTableWriter setOpenResult(boolean openResult) {
        this.txnProxy.openResult = openResult;
        return this;
    }

    public abstract SSTableReader openEarly();

    public abstract SSTableReader openFinalEarly();

    public SSTableReader finish(long repairedAt, long maxDataAge, boolean openResult) {
        if (repairedAt > 0L) {
            this.repairedAt = repairedAt;
        }
        this.maxDataAge = maxDataAge;
        return this.finish(openResult);
    }

    public SSTableReader finish(boolean openResult) {
        this.setOpenResult(openResult);
        this.txnProxy.finish();
        this.observers.forEach(SSTableFlushObserver::complete);
        return this.finished();
    }

    public SSTableReader finished() {
        return this.txnProxy.finalReader;
    }

    @Override
    public final void prepareToCommit() {
        this.txnProxy.prepareToCommit();
    }

    @Override
    public final Throwable commit(Throwable accumulate) {
        try {
            Throwable throwable = this.txnProxy.commit(accumulate);
            return throwable;
        }
        finally {
            this.observers.forEach(SSTableFlushObserver::complete);
        }
    }

    @Override
    public final Throwable abort(Throwable accumulate) {
        return this.txnProxy.abort(accumulate);
    }

    @Override
    public final void close() {
        this.txnProxy.close();
    }

    public final void abort() {
        this.txnProxy.abort();
    }

    protected Map<MetadataType, MetadataComponent> finalizeMetadata() {
        return this.metadataCollector.finalizeMetadata(this.getPartitioner().getClass().getCanonicalName(), this.metadata().params.bloomFilterFpChance, this.repairedAt, this.pendingRepair, this.isTransient, this.header);
    }

    protected StatsMetadata statsMetadata() {
        return (StatsMetadata)this.finalizeMetadata().get((Object)MetadataType.STATS);
    }

    public void releaseMetadataOverhead() {
        this.metadataCollector.release();
    }

    public static void rename(Descriptor tmpdesc, Descriptor newdesc, Set<Component> components) {
        for (Component component : Sets.difference(components, Sets.newHashSet(Component.DATA, Component.SUMMARY))) {
            FileUtils.renameWithConfirm(tmpdesc.filenameFor(component), newdesc.filenameFor(component));
        }
        FileUtils.renameWithConfirm(tmpdesc.filenameFor(Component.DATA), newdesc.filenameFor(Component.DATA));
        FileUtils.renameWithOutConfirm(tmpdesc.filenameFor(Component.SUMMARY), newdesc.filenameFor(Component.SUMMARY));
    }

    public static void copy(Descriptor tmpdesc, Descriptor newdesc, Set<Component> components) {
        for (Component component : Sets.difference(components, Sets.newHashSet(Component.DATA, Component.SUMMARY))) {
            FileUtils.copyWithConfirm(tmpdesc.filenameFor(component), newdesc.filenameFor(component));
        }
        FileUtils.copyWithConfirm(tmpdesc.filenameFor(Component.DATA), newdesc.filenameFor(Component.DATA));
        FileUtils.copyWithOutConfirm(tmpdesc.filenameFor(Component.SUMMARY), newdesc.filenameFor(Component.SUMMARY));
    }

    public static void hardlink(Descriptor tmpdesc, Descriptor newdesc, Set<Component> components) {
        for (Component component : Sets.difference(components, Sets.newHashSet(Component.DATA, Component.SUMMARY))) {
            FileUtils.createHardLinkWithConfirm(tmpdesc.filenameFor(component), newdesc.filenameFor(component));
        }
        FileUtils.createHardLinkWithConfirm(tmpdesc.filenameFor(Component.DATA), newdesc.filenameFor(Component.DATA));
        FileUtils.createHardLinkWithoutConfirm(tmpdesc.filenameFor(Component.SUMMARY), newdesc.filenameFor(Component.SUMMARY));
    }

    public static abstract class Factory {
        public abstract SSTableWriter open(Descriptor var1, long var2, long var4, UUID var6, boolean var7, TableMetadataRef var8, MetadataCollector var9, SerializationHeader var10, Collection<SSTableFlushObserver> var11, LifecycleNewTracker var12);
    }

    protected abstract class TransactionalProxy
    extends Transactional.AbstractTransactional {
        protected SSTableReader finalReader;
        protected boolean openResult;

        protected TransactionalProxy() {
        }
    }
}

