/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.ThrowableUtil;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.apache.cassandra.utils.concurrent.WaitQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncPromise<V>
implements Promise<V> {
    private static final Logger logger = LoggerFactory.getLogger(AsyncPromise.class);
    private final EventExecutor executor;
    private volatile Object result;
    private volatile GenericFutureListener<? extends Future<? super V>> listeners;
    private volatile WaitQueue waiting;
    private static final AtomicReferenceFieldUpdater<AsyncPromise, Object> resultUpdater = AtomicReferenceFieldUpdater.newUpdater(AsyncPromise.class, Object.class, "result");
    private static final AtomicReferenceFieldUpdater<AsyncPromise, GenericFutureListener> listenersUpdater = AtomicReferenceFieldUpdater.newUpdater(AsyncPromise.class, GenericFutureListener.class, "listeners");
    private static final AtomicReferenceFieldUpdater<AsyncPromise, WaitQueue> waitingUpdater = AtomicReferenceFieldUpdater.newUpdater(AsyncPromise.class, WaitQueue.class, "waiting");
    private static final FailureHolder UNSET = new FailureHolder(null);
    private static final FailureHolder UNCANCELLABLE = new FailureHolder(null);
    private static final FailureHolder CANCELLED = new FailureHolder(ThrowableUtil.unknownStackTrace(new CancellationException(), AsyncPromise.class, "cancel(...)"));
    private static final DeferredGenericFutureListener NOTIFYING = future -> {};

    public AsyncPromise(EventExecutor executor) {
        this(executor, UNSET);
    }

    private AsyncPromise(EventExecutor executor, FailureHolder initialState) {
        this.executor = executor;
        this.result = initialState;
    }

    public AsyncPromise(EventExecutor executor, GenericFutureListener<? extends Future<? super V>> listener) {
        this(executor);
        this.listeners = listener;
    }

    AsyncPromise(EventExecutor executor, FailureHolder initialState, GenericFutureListener<? extends Future<? super V>> listener) {
        this(executor, initialState);
        this.listeners = listener;
    }

    public static <V> AsyncPromise<V> uncancellable(EventExecutor executor) {
        return new AsyncPromise<V>(executor, UNCANCELLABLE);
    }

    public static <V> AsyncPromise<V> uncancellable(EventExecutor executor, GenericFutureListener<? extends Future<? super V>> listener) {
        return new AsyncPromise<V>(executor, UNCANCELLABLE);
    }

    @Override
    public Promise<V> setSuccess(V v) {
        if (!this.trySuccess(v)) {
            throw new IllegalStateException("complete already: " + this);
        }
        return this;
    }

    @Override
    public Promise<V> setFailure(Throwable throwable) {
        if (!this.tryFailure(throwable)) {
            throw new IllegalStateException("complete already: " + this);
        }
        return this;
    }

    @Override
    public boolean trySuccess(V v) {
        return this.trySet(v);
    }

    @Override
    public boolean tryFailure(Throwable throwable) {
        return this.trySet(new FailureHolder(throwable));
    }

    @Override
    public boolean setUncancellable() {
        if (this.trySet(UNCANCELLABLE)) {
            return true;
        }
        return this.result == UNCANCELLABLE;
    }

    @Override
    public boolean cancel(boolean b) {
        return this.trySet(CANCELLED);
    }

    private boolean trySet(Object v) {
        Object current;
        do {
            if (!AsyncPromise.isDone(current = this.result) && (current != UNCANCELLABLE || v != CANCELLED)) continue;
            return false;
        } while (!resultUpdater.compareAndSet(this, current, v));
        if (v != UNCANCELLABLE) {
            this.notifyListeners();
            this.notifyWaiters();
        }
        return true;
    }

    @Override
    public boolean isSuccess() {
        return AsyncPromise.isSuccess(this.result);
    }

    private static boolean isSuccess(Object result) {
        return !(result instanceof FailureHolder);
    }

    @Override
    public boolean isCancelled() {
        return AsyncPromise.isCancelled(this.result);
    }

    private static boolean isCancelled(Object result) {
        return result == CANCELLED;
    }

    @Override
    public boolean isDone() {
        return AsyncPromise.isDone(this.result);
    }

    private static boolean isDone(Object result) {
        return result != UNSET && result != UNCANCELLABLE;
    }

    @Override
    public boolean isCancellable() {
        Object result = this.result;
        return result == UNSET;
    }

    @Override
    public Throwable cause() {
        Object result = this.result;
        if (result instanceof FailureHolder) {
            return ((FailureHolder)result).cause;
        }
        return null;
    }

    @Override
    public V getNow() {
        Object result = this.result;
        if (AsyncPromise.isSuccess(result)) {
            return (V)result;
        }
        return null;
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        this.await();
        return this.getWhenDone();
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (!this.await(timeout, unit)) {
            throw new TimeoutException();
        }
        return this.getWhenDone();
    }

    private V getWhenDone() throws ExecutionException {
        Object result = this.result;
        if (AsyncPromise.isSuccess(result)) {
            return (V)result;
        }
        if (result == CANCELLED) {
            throw new CancellationException();
        }
        throw new ExecutionException(((FailureHolder)result).cause);
    }

    @Override
    public Promise<V> sync() throws InterruptedException {
        this.await();
        this.rethrowIfFailed();
        return this;
    }

    @Override
    public Promise<V> syncUninterruptibly() {
        this.awaitUninterruptibly();
        this.rethrowIfFailed();
        return this;
    }

    private void rethrowIfFailed() {
        Throwable cause = this.cause();
        if (cause != null) {
            PlatformDependent.throwException(cause);
        }
    }

    @Override
    public Promise<V> addListener(GenericFutureListener<? extends Future<? super V>> listener) {
        listenersUpdater.accumulateAndGet(this, listener, AsyncPromise::appendListener);
        if (this.isDone()) {
            this.notifyListeners();
        }
        return this;
    }

    @Override
    public Promise<V> addListeners(GenericFutureListener<? extends Future<? super V>> ... listeners) {
        return this.addListener((F future) -> {
            for (GenericFutureListener listener : listeners) {
                AsyncPromise.invokeListener(listener, future);
            }
        });
    }

    @Override
    public Promise<V> removeListener(GenericFutureListener<? extends Future<? super V>> listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Promise<V> removeListeners(GenericFutureListener<? extends Future<? super V>> ... listeners) {
        throw new UnsupportedOperationException();
    }

    private void notifyListeners() {
        if (!this.executor.inEventLoop()) {
            this.executor.execute(this::notifyListeners);
            return;
        }
        if (this.listeners == null || this.listeners instanceof DeferredGenericFutureListener) {
            return;
        }
        do {
            GenericFutureListener listeners;
            if ((listeners = listenersUpdater.getAndSet(this, NOTIFYING)) == null) continue;
            AsyncPromise.invokeListener(listeners, this);
        } while (!listenersUpdater.compareAndSet(this, NOTIFYING, null));
    }

    private static <F extends Future<?>> void invokeListener(GenericFutureListener<F> listener, F future) {
        try {
            listener.operationComplete(future);
        }
        catch (Throwable t) {
            logger.error("Failed to invoke listener {} to {}", new Object[]{listener, future, t});
        }
    }

    private static <F extends Future<?>> GenericFutureListener<F> appendListener(GenericFutureListener<F> prevListener, GenericFutureListener<F> newListener) {
        DeferredGenericFutureListener result = newListener;
        if (prevListener != null && prevListener != NOTIFYING) {
            result = future -> {
                AsyncPromise.invokeListener(prevListener, future);
                newListener.operationComplete(future);
            };
        }
        if (prevListener instanceof DeferredGenericFutureListener) {
            GenericFutureListener wrap = result;
            result = wrap::operationComplete;
        }
        return result;
    }

    @Override
    public Promise<V> await() throws InterruptedException {
        this.await(0L, (WaitQueue.Signal signal, long nanos) -> {
            signal.await();
            return true;
        });
        return this;
    }

    @Override
    public Promise<V> awaitUninterruptibly() {
        this.await(0L, (WaitQueue.Signal signal, long nanos) -> {
            signal.awaitUninterruptibly();
            return true;
        });
        return this;
    }

    @Override
    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        return this.await(unit.toNanos(timeout), (WaitQueue.Signal signal, long nanos) -> signal.awaitUntil(nanos + System.nanoTime()));
    }

    @Override
    public boolean await(long timeoutMillis) throws InterruptedException {
        return this.await(timeoutMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    public boolean awaitUninterruptibly(long timeout, TimeUnit unit) {
        return this.await(unit.toNanos(timeout), (WaitQueue.Signal signal, long nanos) -> signal.awaitUntilUninterruptibly(nanos + System.nanoTime()));
    }

    @Override
    public boolean awaitUninterruptibly(long timeoutMillis) {
        return this.awaitUninterruptibly(timeoutMillis, TimeUnit.MILLISECONDS);
    }

    private <T extends Throwable> boolean await(long nanos, Awaiter<T> awaiter) throws T {
        if (this.isDone()) {
            return true;
        }
        WaitQueue.Signal await = this.registerToWait();
        if (null != await) {
            return awaiter.await(await, nanos);
        }
        return true;
    }

    private WaitQueue.Signal registerToWait() {
        WaitQueue waiting = this.waiting;
        if (waiting == null && !waitingUpdater.compareAndSet(this, null, waiting = new WaitQueue())) {
            waiting = this.waiting;
        }
        assert (waiting != null);
        WaitQueue.Signal signal = waiting.register();
        if (!this.isDone()) {
            return signal;
        }
        signal.cancel();
        return null;
    }

    private void notifyWaiters() {
        WaitQueue waiting = this.waiting;
        if (waiting != null) {
            waiting.signalAll();
        }
    }

    public String toString() {
        Object result = this.result;
        if (AsyncPromise.isSuccess(result)) {
            return "(success: " + result + ')';
        }
        if (result == UNCANCELLABLE) {
            return "(uncancellable)";
        }
        if (result == CANCELLED) {
            return "(cancelled)";
        }
        if (AsyncPromise.isDone(result)) {
            return "(failure: " + ((FailureHolder)result).cause + ')';
        }
        return "(incomplete)";
    }

    static interface Awaiter<T extends Throwable> {
        public boolean await(WaitQueue.Signal var1, long var2) throws T;
    }

    private static final class FailureHolder {
        final Throwable cause;

        private FailureHolder(Throwable cause) {
            this.cause = cause;
        }
    }

    private static interface DeferredGenericFutureListener<F extends Future<?>>
    extends GenericFutureListener<F> {
    }
}

