/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import com.google.common.base.Preconditions;
import java.net.InetAddress;
import java.util.function.Function;
import org.apache.cassandra.auth.IInternodeAuthenticator;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.EncryptionOptions;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.net.AcceptVersions;
import org.apache.cassandra.net.InboundMessageHandlers;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.net.SocketFactory;
import org.apache.cassandra.utils.FBUtilities;

public class InboundConnectionSettings {
    public final IInternodeAuthenticator authenticator;
    public final InetAddressAndPort bindAddress;
    public final EncryptionOptions.ServerEncryptionOptions encryption;
    public final Integer socketReceiveBufferSizeInBytes;
    public final Integer applicationReceiveQueueCapacityInBytes;
    public final AcceptVersions acceptMessaging;
    public final AcceptVersions acceptStreaming;
    public final SocketFactory socketFactory;
    public final Function<InetAddressAndPort, InboundMessageHandlers> handlers;

    private InboundConnectionSettings(IInternodeAuthenticator authenticator, InetAddressAndPort bindAddress, EncryptionOptions.ServerEncryptionOptions encryption, Integer socketReceiveBufferSizeInBytes, Integer applicationReceiveQueueCapacityInBytes, AcceptVersions acceptMessaging, AcceptVersions acceptStreaming, SocketFactory socketFactory, Function<InetAddressAndPort, InboundMessageHandlers> handlers) {
        this.authenticator = authenticator;
        this.bindAddress = bindAddress;
        this.encryption = encryption;
        this.socketReceiveBufferSizeInBytes = socketReceiveBufferSizeInBytes;
        this.applicationReceiveQueueCapacityInBytes = applicationReceiveQueueCapacityInBytes;
        this.acceptMessaging = acceptMessaging;
        this.acceptStreaming = acceptStreaming;
        this.socketFactory = socketFactory;
        this.handlers = handlers;
    }

    public InboundConnectionSettings() {
        this(null, null, null, null, null, null, null, null, null);
    }

    public boolean authenticate(InetAddressAndPort endpoint) {
        return this.authenticator.authenticate(endpoint.address, endpoint.port);
    }

    public boolean authenticate(InetAddress address, int port) {
        return this.authenticator.authenticate(address, port);
    }

    public String toString() {
        return String.format("address: (%s), nic: %s, encryption: %s", this.bindAddress, FBUtilities.getNetworkInterface(this.bindAddress.address), SocketFactory.encryptionOptionsSummary(this.encryption));
    }

    public InboundConnectionSettings withAuthenticator(IInternodeAuthenticator authenticator) {
        return new InboundConnectionSettings(authenticator, this.bindAddress, this.encryption, this.socketReceiveBufferSizeInBytes, this.applicationReceiveQueueCapacityInBytes, this.acceptMessaging, this.acceptStreaming, this.socketFactory, this.handlers);
    }

    public InboundConnectionSettings withBindAddress(InetAddressAndPort bindAddress) {
        return new InboundConnectionSettings(this.authenticator, bindAddress, this.encryption, this.socketReceiveBufferSizeInBytes, this.applicationReceiveQueueCapacityInBytes, this.acceptMessaging, this.acceptStreaming, this.socketFactory, this.handlers);
    }

    public InboundConnectionSettings withEncryption(EncryptionOptions.ServerEncryptionOptions encryption) {
        return new InboundConnectionSettings(this.authenticator, this.bindAddress, encryption, this.socketReceiveBufferSizeInBytes, this.applicationReceiveQueueCapacityInBytes, this.acceptMessaging, this.acceptStreaming, this.socketFactory, this.handlers);
    }

    public InboundConnectionSettings withSocketReceiveBufferSizeInBytes(int socketReceiveBufferSizeInBytes) {
        return new InboundConnectionSettings(this.authenticator, this.bindAddress, this.encryption, socketReceiveBufferSizeInBytes, this.applicationReceiveQueueCapacityInBytes, this.acceptMessaging, this.acceptStreaming, this.socketFactory, this.handlers);
    }

    public InboundConnectionSettings withApplicationReceiveQueueCapacityInBytes(int applicationReceiveQueueCapacityInBytes) {
        return new InboundConnectionSettings(this.authenticator, this.bindAddress, this.encryption, this.socketReceiveBufferSizeInBytes, applicationReceiveQueueCapacityInBytes, this.acceptMessaging, this.acceptStreaming, this.socketFactory, this.handlers);
    }

    public InboundConnectionSettings withAcceptMessaging(AcceptVersions acceptMessaging) {
        return new InboundConnectionSettings(this.authenticator, this.bindAddress, this.encryption, this.socketReceiveBufferSizeInBytes, this.applicationReceiveQueueCapacityInBytes, acceptMessaging, this.acceptStreaming, this.socketFactory, this.handlers);
    }

    public InboundConnectionSettings withAcceptStreaming(AcceptVersions acceptMessaging) {
        return new InboundConnectionSettings(this.authenticator, this.bindAddress, this.encryption, this.socketReceiveBufferSizeInBytes, this.applicationReceiveQueueCapacityInBytes, acceptMessaging, this.acceptStreaming, this.socketFactory, this.handlers);
    }

    public InboundConnectionSettings withSocketFactory(SocketFactory socketFactory) {
        return new InboundConnectionSettings(this.authenticator, this.bindAddress, this.encryption, this.socketReceiveBufferSizeInBytes, this.applicationReceiveQueueCapacityInBytes, this.acceptMessaging, this.acceptStreaming, socketFactory, this.handlers);
    }

    public InboundConnectionSettings withHandlers(Function<InetAddressAndPort, InboundMessageHandlers> handlers) {
        return new InboundConnectionSettings(this.authenticator, this.bindAddress, this.encryption, this.socketReceiveBufferSizeInBytes, this.applicationReceiveQueueCapacityInBytes, this.acceptMessaging, this.acceptStreaming, this.socketFactory, handlers);
    }

    public InboundConnectionSettings withLegacySslStoragePortDefaults() {
        EncryptionOptions.ServerEncryptionOptions encryption = this.encryption;
        if (encryption == null) {
            encryption = DatabaseDescriptor.getInternodeMessagingEncyptionOptions();
        }
        encryption = encryption.withOptional(false).withInternodeEncryption(EncryptionOptions.ServerEncryptionOptions.InternodeEncryption.all);
        return this.withBindAddress(this.bindAddress.withPort(DatabaseDescriptor.getSSLStoragePort())).withEncryption(encryption).withDefaults();
    }

    public InboundConnectionSettings withDefaults() {
        if (this.bindAddress.port != DatabaseDescriptor.getStoragePort() && this.bindAddress.port != DatabaseDescriptor.getSSLStoragePort()) {
            throw new ConfigurationException(String.format("Local endpoint port %d doesn't match YAML configured port %d or legacy SSL port %d", this.bindAddress.port, DatabaseDescriptor.getStoragePort(), DatabaseDescriptor.getSSLStoragePort()));
        }
        IInternodeAuthenticator authenticator = this.authenticator;
        EncryptionOptions.ServerEncryptionOptions encryption = this.encryption;
        Integer socketReceiveBufferSizeInBytes = this.socketReceiveBufferSizeInBytes;
        Integer applicationReceiveQueueCapacityInBytes = this.applicationReceiveQueueCapacityInBytes;
        AcceptVersions acceptMessaging = this.acceptMessaging;
        AcceptVersions acceptStreaming = this.acceptStreaming;
        SocketFactory socketFactory = this.socketFactory;
        Function<InetAddressAndPort, InboundMessageHandlers> handlersFactory = this.handlers;
        if (authenticator == null) {
            authenticator = DatabaseDescriptor.getInternodeAuthenticator();
        }
        if (encryption == null) {
            encryption = DatabaseDescriptor.getInternodeMessagingEncyptionOptions();
        }
        if (socketReceiveBufferSizeInBytes == null) {
            socketReceiveBufferSizeInBytes = DatabaseDescriptor.getInternodeSocketReceiveBufferSizeInBytes();
        }
        if (applicationReceiveQueueCapacityInBytes == null) {
            applicationReceiveQueueCapacityInBytes = DatabaseDescriptor.getInternodeApplicationReceiveQueueCapacityInBytes();
        }
        if (acceptMessaging == null) {
            acceptMessaging = MessagingService.accept_messaging;
        }
        if (acceptStreaming == null) {
            acceptStreaming = MessagingService.accept_streaming;
        }
        if (socketFactory == null) {
            socketFactory = MessagingService.instance().socketFactory;
        }
        if (handlersFactory == null) {
            handlersFactory = MessagingService.instance()::getInbound;
        }
        Preconditions.checkArgument(socketReceiveBufferSizeInBytes == 0 || socketReceiveBufferSizeInBytes >= 1024, "illegal socket send buffer size: " + socketReceiveBufferSizeInBytes);
        Preconditions.checkArgument(applicationReceiveQueueCapacityInBytes >= 1024, "illegal application receive queue capacity: " + applicationReceiveQueueCapacityInBytes);
        return new InboundConnectionSettings(authenticator, this.bindAddress, encryption, socketReceiveBufferSizeInBytes, applicationReceiveQueueCapacityInBytes, acceptMessaging, acceptStreaming, socketFactory, handlersFactory);
    }
}

