/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.meta;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.celeborn.common.meta.FileMeta;

public class ReduceFileMeta
implements FileMeta {
    private final AtomicBoolean sorted = new AtomicBoolean(false);
    private final List<Long> chunkOffsets;
    private long chunkSize;
    private long nextBoundary;

    public ReduceFileMeta(long chunkSize) {
        this.chunkOffsets = new ArrayList<Long>();
        this.chunkOffsets.add(0L);
        this.chunkSize = chunkSize;
        this.nextBoundary = chunkSize;
    }

    public ReduceFileMeta(List<Long> chunkOffsets, long chunkSize) {
        this.chunkOffsets = chunkOffsets;
        this.nextBoundary = chunkSize;
        if (!chunkOffsets.isEmpty()) {
            this.nextBoundary += chunkOffsets.get(chunkOffsets.size() - 1).longValue();
        }
        this.chunkSize = chunkSize;
    }

    public ReduceFileMeta(List<Long> chunkOffsets) {
        this.chunkOffsets = chunkOffsets;
    }

    public synchronized List<Long> getChunkOffsets() {
        return this.chunkOffsets;
    }

    public synchronized void addChunkOffset(long offset) {
        this.nextBoundary = offset + this.chunkSize;
        if (this.chunkOffsets.isEmpty() || this.chunkOffsets.get(this.chunkOffsets.size() - 1) != offset) {
            this.chunkOffsets.add(offset);
        }
    }

    public void updateChunkOffset(long bytesFlushed, boolean force) {
        if (bytesFlushed >= this.nextBoundary || force) {
            this.addChunkOffset(bytesFlushed);
        }
    }

    public synchronized long getLastChunkOffset() {
        return this.chunkOffsets.get(this.chunkOffsets.size() - 1);
    }

    public synchronized int getNumChunks() {
        if (this.chunkOffsets.isEmpty()) {
            return 0;
        }
        return this.chunkOffsets.size() - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSorted() {
        AtomicBoolean atomicBoolean = this.sorted;
        synchronized (atomicBoolean) {
            this.sorted.set(true);
        }
    }

    public AtomicBoolean getSorted() {
        return this.sorted;
    }
}

