/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.mapreduce.v2.app;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import org.apache.celeborn.client.LifecycleManager;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.exception.CelebornIOException;
import org.apache.celeborn.util.HadoopUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.ipc.CallerContext;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.JobSubmissionFiles;
import org.apache.hadoop.mapreduce.v2.app.MRAppMaster;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.mapreduce.v2.util.MRWebAppUtil;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.ShutdownHookManager;
import org.apache.hadoop.yarn.YarnUncaughtExceptionHandler;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MRAppMasterWithCeleborn
extends MRAppMaster {
    private static final Logger logger = LoggerFactory.getLogger(MRAppMasterWithCeleborn.class);
    private static final String MASTER_ENDPOINTS_ENV = "CELEBORN_MASTER_ENDPOINTS";

    public MRAppMasterWithCeleborn(ApplicationAttemptId applicationAttemptId, ContainerId containerId, String nmHost, int nmPort, int nmHttpPort, long appSubmitTime, JobConf jobConf) throws CelebornIOException {
        super(applicationAttemptId, containerId, nmHost, nmPort, nmHttpPort, appSubmitTime);
        int numReducers = jobConf.getInt("mapreduce.job.reduces", 0);
        if (numReducers > 0) {
            CelebornConf conf = HadoopUtils.fromYarnConf(jobConf);
            String appUniqueId = conf.appUniqueIdWithUUIDSuffix(applicationAttemptId.toString());
            LifecycleManager lifecycleManager = new LifecycleManager(appUniqueId, conf);
            String lmHost = lifecycleManager.getHost();
            int lmPort = lifecycleManager.getPort();
            logger.info("MRAppMaster initialized with {} {} {}", new Object[]{lmHost, lmPort, appUniqueId});
            JobConf lmConf = new JobConf();
            lmConf.clear();
            lmConf.set("celeborn.lifecycleManager.host", lmHost);
            lmConf.set("celeborn.lifecycleManager.port", lmPort + "");
            lmConf.set("celeborn.applicationId", appUniqueId);
            this.writeLifecycleManagerConfToTask(jobConf, lmConf);
        }
    }

    private void writeLifecycleManagerConfToTask(JobConf conf, JobConf lmConf) throws CelebornIOException {
        try {
            String jobDirStr = conf.get("mapreduce.job.dir");
            Path celebornConfPath = new Path(jobDirStr, "celeborn.xml");
            FileSystem fs = celebornConfPath.getFileSystem((Configuration)conf);
            try (FSDataOutputStream out = FileSystem.create((FileSystem)fs, (Path)celebornConfPath, (FsPermission)new FsPermission(JobSubmissionFiles.JOB_FILE_PERMISSION));){
                lmConf.writeXml((OutputStream)out);
            }
            FileStatus status = fs.getFileStatus(celebornConfPath);
            long currentTs = status.getModificationTime();
            String uri = celebornConfPath.toUri().isAbsolute() ? celebornConfPath.toUri().toString() : fs.getUri() + "/" + celebornConfPath.toUri();
            String files = conf.get("mapreduce.job.cache.files");
            conf.set("mapreduce.job.cache.files", files == null ? uri : uri + "," + files);
            String ts = conf.get("mapreduce.job.cache.files.timestamps");
            conf.set("mapreduce.job.cache.files.timestamps", ts == null ? String.valueOf(currentTs) : currentTs + "," + ts);
            String vis = conf.get("mapreduce.job.cache.files.visibilities");
            conf.set("mapreduce.job.cache.files.visibilities", vis == null ? "false" : "false," + vis);
            long size = status.getLen();
            String sizes = conf.get("mapreduce.job.cache.files.filesizes");
            conf.set("mapreduce.job.cache.files.filesizes", sizes == null ? String.valueOf(size) : size + "," + sizes);
        }
        catch (IOException e) {
            logger.error("Upload extra conf exception", (Throwable)e);
            throw new CelebornIOException("Upload extra conf exception ", (Throwable)e);
        }
    }

    private static String ensureGetSysEnv(String envName) throws IOException {
        String value = System.getenv(envName);
        if (value == null) {
            String msg = envName + " is null";
            logger.error(msg);
            throw new CelebornIOException(msg);
        }
        return value;
    }

    public static void main(String[] args) {
        JobConf rmAppConf = new JobConf((Configuration)new YarnConfiguration());
        rmAppConf.addResource(new Path("job.xml"));
        try {
            MRAppMasterWithCeleborn.checkJobConf(rmAppConf);
            Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new YarnUncaughtExceptionHandler());
            String containerIdStr = MRAppMasterWithCeleborn.ensureGetSysEnv(ApplicationConstants.Environment.CONTAINER_ID.name());
            String nodeHostString = MRAppMasterWithCeleborn.ensureGetSysEnv(ApplicationConstants.Environment.NM_HOST.name());
            String nodePortString = MRAppMasterWithCeleborn.ensureGetSysEnv(ApplicationConstants.Environment.NM_PORT.name());
            String nodeHttpPortString = MRAppMasterWithCeleborn.ensureGetSysEnv(ApplicationConstants.Environment.NM_HTTP_PORT.name());
            String appSubmitTimeStr = MRAppMasterWithCeleborn.ensureGetSysEnv("APP_SUBMIT_TIME_ENV");
            ContainerId containerId = ContainerId.fromString((String)containerIdStr);
            ApplicationAttemptId applicationAttemptId = containerId.getApplicationAttemptId();
            if (applicationAttemptId != null) {
                CallerContext.setCurrent((CallerContext)new CallerContext.Builder("mr_app_master_with_celeborn_" + applicationAttemptId).build());
            }
            long appSubmitTime = Long.parseLong(appSubmitTimeStr);
            MRAppMasterWithCeleborn appMaster = new MRAppMasterWithCeleborn(applicationAttemptId, containerId, nodeHostString, Integer.parseInt(nodePortString), Integer.parseInt(nodeHttpPortString), appSubmitTime, rmAppConf);
            try {
                Field field = MRAppMaster.class.getDeclaredField("mainStarted");
                field.setAccessible(true);
                field.setBoolean(null, true);
                field.setAccessible(false);
            }
            catch (NoSuchFieldException field) {
                // empty catch block
            }
            ShutdownHookManager.get().addShutdownHook(() -> {
                logger.info("MRAppMasterWithCeleborn received stop signal.");
                appMaster.notifyIsLastAMRetry(appMaster.isLastAMRetry);
                appMaster.stop();
            }, 30);
            MRWebAppUtil.initialize((Configuration)rmAppConf);
            String systemPropsToLog = MRApps.getSystemPropertiesToLog((Configuration)rmAppConf);
            if (systemPropsToLog != null) {
                logger.info(systemPropsToLog);
            }
            String jobUserName = System.getenv(ApplicationConstants.Environment.USER.name());
            rmAppConf.set("mapreduce.job.user.name", jobUserName);
            MRAppMasterWithCeleborn.initAndStartAppMaster((MRAppMaster)appMaster, (JobConf)rmAppConf, (String)jobUserName);
        }
        catch (Throwable t) {
            logger.error("Error starting MRAppMaster", t);
            ExitUtil.terminate((int)1, (Throwable)t);
        }
    }

    public static void checkJobConf(JobConf conf) throws IOException {
        String masterEndpointsKey;
        String masterEndpointsVal;
        if (conf.getBoolean("yarn.app.mapreduce.am.job.recovery.enable", false)) {
            logger.warn("MRAppMaster disables job recovery.");
            conf.setBoolean("yarn.app.mapreduce.am.job.recovery.enable", false);
        }
        if (conf.getFloat("mapreduce.job.reduce.slowstart.completedmaps", 0.05f) != 1.0f) {
            logger.warn("MRAppMaster disables job reduce slow start.");
            conf.setFloat("mapreduce.job.reduce.slowstart.completedmaps", 1.0f);
        }
        if ((masterEndpointsVal = conf.get(masterEndpointsKey = "mapreduce." + CelebornConf.MASTER_ENDPOINTS().key())) == null || masterEndpointsVal.isEmpty()) {
            logger.info("MRAppMaster sets {} via environment variable {}.", (Object)masterEndpointsKey, (Object)MASTER_ENDPOINTS_ENV);
            conf.set(masterEndpointsKey, MRAppMasterWithCeleborn.ensureGetSysEnv(MASTER_ENDPOINTS_ENV));
        }
    }
}

