/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle.celeborn;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.celeborn.common.protocol.PartitionLocation;
import org.apache.celeborn.shaded.org.apache.commons.lang3.tuple.Pair;

public class CelebornPartitionUtil {
    public static Map<String, Pair<Integer, Integer>> splitSkewedPartitionLocations(ArrayList<PartitionLocation> locations, int subPartitionSize, int subPartitionIndex) {
        locations.sort(Comparator.comparing(p -> p.getUniqueId()));
        long totalPartitionSize = locations.stream().mapToLong(p -> p.getStorageInfo().fileSize).sum();
        long step = totalPartitionSize / (long)subPartitionSize;
        long startOffset = step * (long)subPartitionIndex;
        long endOffset = subPartitionIndex < subPartitionSize - 1 ? step * (long)(subPartitionIndex + 1) : totalPartitionSize + 1L;
        long partitionLocationOffset = 0L;
        HashMap<String, Pair<Integer, Integer>> chunkRange = new HashMap<String, Pair<Integer, Integer>>();
        for (PartitionLocation p2 : locations) {
            int left = -1;
            int right = -1;
            Iterator<Long> chunkOffsets = p2.getStorageInfo().getChunkOffsets().iterator();
            chunkOffsets.next();
            int j = 1;
            while (chunkOffsets.hasNext()) {
                long currentOffset = partitionLocationOffset + chunkOffsets.next();
                if (currentOffset > startOffset && left < 0) {
                    left = j - 1;
                }
                if (currentOffset <= endOffset) {
                    right = j - 1;
                }
                if (left >= 0 && right >= 0 && right >= left) {
                    chunkRange.put(p2.getUniqueId(), Pair.of(left, right));
                }
                ++j;
            }
            if ((partitionLocationOffset += p2.getStorageInfo().getFileSize()) <= endOffset) continue;
            break;
        }
        return chunkRange;
    }
}

