/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.network.protocol;

import io.netty.buffer.ByteBuf;
import java.util.Objects;
import org.apache.celeborn.common.network.buffer.NettyManagedBuffer;
import org.apache.celeborn.common.network.protocol.Message;
import org.apache.celeborn.common.network.protocol.RequestMessage;

public class ReadData
extends RequestMessage {
    protected long streamId;

    public ReadData(long streamId, ByteBuf buf) {
        super(new NettyManagedBuffer(buf));
        this.streamId = streamId;
    }

    @Override
    public int encodedLength() {
        return 8;
    }

    @Override
    public void encode(ByteBuf buf) {
        buf.writeLong(this.streamId);
    }

    public long getStreamId() {
        return this.streamId;
    }

    @Override
    public Message.Type type() {
        return Message.Type.READ_DATA;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReadData readData = (ReadData)o;
        return this.streamId == readData.streamId && super.equals(o);
    }

    public int hashCode() {
        return Objects.hash(this.streamId, super.hashCode());
    }

    public String toString() {
        return "ReadData{streamId=" + this.streamId + '}';
    }
}

