/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.meta;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.celeborn.common.meta.FileMeta;

public class MapFileMeta
implements FileMeta {
    private int bufferSize;
    private int numSubPartitions;
    private String mountPoint;
    private Map<Integer, Integer> subPartitionWritingSegmentId;
    private List<SegmentIndex> subPartitionSegmentIndexes;
    private volatile boolean isWriterClosed;
    private boolean isSegmentGranularityVisible;

    public MapFileMeta() {
    }

    public MapFileMeta(int bufferSize, int numSubPartitions) {
        this(bufferSize, numSubPartitions, false, Collections.emptyMap(), Collections.emptyList());
    }

    public MapFileMeta(int bufferSize, int numSubPartitions, boolean isSegmentGranularityVisible, Map<Integer, Integer> subPartitionWritingSegmentId, List<SegmentIndex> subPartitionSegmentIndexes) {
        this.bufferSize = bufferSize;
        this.numSubPartitions = numSubPartitions;
        this.isSegmentGranularityVisible = isSegmentGranularityVisible;
        this.subPartitionWritingSegmentId = subPartitionWritingSegmentId;
        this.subPartitionSegmentIndexes = subPartitionSegmentIndexes;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public int getNumSubPartitions() {
        return this.numSubPartitions;
    }

    public void setNumSubPartitions(int numSubPartitions) {
        this.numSubPartitions = numSubPartitions;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public void setMountPoint(String mountPoint) {
        this.mountPoint = mountPoint;
    }

    public void setIsWriterClosed(boolean isWriterClosed) {
        this.isWriterClosed = isWriterClosed;
    }

    public void setSubPartitionWritingSegmentId(Map<Integer, Integer> subPartitionWritingSegmentId) {
        this.subPartitionWritingSegmentId = subPartitionWritingSegmentId;
    }

    public void setSubPartitionSegmentIndexes(List<SegmentIndex> subPartitionSegmentIndexes) {
        this.subPartitionSegmentIndexes = subPartitionSegmentIndexes;
    }

    public String getMountPoint() {
        return this.mountPoint;
    }

    public int getNumSubpartitions() {
        return this.numSubPartitions;
    }

    public Map<Integer, Integer> getSubPartitionWritingSegmentId() {
        return this.subPartitionWritingSegmentId;
    }

    public List<SegmentIndex> getSubPartitionSegmentIndexes() {
        return this.subPartitionSegmentIndexes;
    }

    public boolean isWriterClosed() {
        return this.isWriterClosed;
    }

    public boolean isSegmentGranularityVisible() {
        return this.isSegmentGranularityVisible;
    }

    public void setSegmentGranularityVisible(boolean segmentGranularityVisible) {
        this.isSegmentGranularityVisible = segmentGranularityVisible;
    }

    public synchronized void addPartitionSegmentId(int supPartitionId, int segmentId) {
        if (this.subPartitionWritingSegmentId == null) {
            this.subPartitionWritingSegmentId = new HashMap<Integer, Integer>();
        }
        this.subPartitionWritingSegmentId.put(supPartitionId, segmentId);
    }

    public synchronized boolean hasPartitionSegmentIds() {
        return this.subPartitionWritingSegmentId != null;
    }

    public synchronized int getPartitionWritingSegmentId(int supPartitionId) {
        return this.subPartitionWritingSegmentId.get(supPartitionId);
    }

    public synchronized void addSegmentIdAndFirstBufferIndex(int subPartitionId, int firstBufferIndex, int segmentId) {
        if (this.subPartitionSegmentIndexes == null) {
            this.subPartitionSegmentIndexes = new ArrayList<SegmentIndex>();
            for (int i = 0; i < this.numSubPartitions; ++i) {
                this.subPartitionSegmentIndexes.add(new SegmentIndex(new HashMap<Integer, Integer>()));
            }
        }
        this.subPartitionSegmentIndexes.get(subPartitionId).addFirstBufferIndexAndSegmentId(firstBufferIndex, segmentId);
    }

    public synchronized Integer getSegmentIdByFirstBufferIndex(int subPartitionId, int bufferIndex) {
        if (this.subPartitionSegmentIndexes == null) {
            return null;
        }
        return this.subPartitionSegmentIndexes.size() > subPartitionId ? this.subPartitionSegmentIndexes.get(subPartitionId).getFirstBufferIndexToSegment().get(bufferIndex) : null;
    }

    public static class SegmentIndex {
        private final Map<Integer, Integer> firstBufferIndexToSegment;

        public SegmentIndex(Map<Integer, Integer> firstBufferIndexToSegment) {
            this.firstBufferIndexToSegment = firstBufferIndexToSegment;
        }

        public Map<Integer, Integer> getFirstBufferIndexToSegment() {
            return this.firstBufferIndexToSegment;
        }

        void addFirstBufferIndexAndSegmentId(int firstBufferIndex, int segmentId) {
            this.firstBufferIndexToSegment.put(firstBufferIndex, segmentId);
        }
    }
}

