/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.functors;

import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.functors.AbstractPredicateTest;
import org.apache.commons.collections4.functors.EqualPredicate;
import org.apache.commons.collections4.functors.NullPredicate;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class EqualPredicateTest
extends AbstractPredicateTest {
    private static final EqualsTestObject FALSE_OBJECT = new EqualsTestObject(false);
    private static final EqualsTestObject TRUE_OBJECT = new EqualsTestObject(true);

    protected Predicate<Object> generatePredicate() {
        return EqualPredicate.equalPredicate(null);
    }

    @Test
    public void testNullArgumentEqualsNullPredicate() throws Exception {
        Assertions.assertSame((Object)NullPredicate.nullPredicate(), (Object)EqualPredicate.equalPredicate(null));
    }

    @Test
    public void testObjectFactoryUsesEqualsForTest() throws Exception {
        Predicate predicate = EqualPredicate.equalPredicate((Object)FALSE_OBJECT);
        this.assertPredicateFalse(predicate, null);
        this.assertPredicateFalse(predicate, TRUE_OBJECT);
        this.assertPredicateTrue(predicate, FALSE_OBJECT);
        this.assertPredicateFalse(predicate, new EqualsTestObject(false));
        this.assertPredicateTrue(EqualPredicate.equalPredicate((Object)TRUE_OBJECT), TRUE_OBJECT);
    }

    @Test
    public void testPredicateTypeCanBeSuperClassOfObject() throws Exception {
        Predicate predicate = EqualPredicate.equalPredicate((Object)4);
        this.assertPredicateTrue(predicate, 4);
    }

    public static class EqualsTestObject {
        private final boolean b;

        public EqualsTestObject(boolean b) {
            this.b = b;
        }

        public boolean equals(Object obj) {
            return this.b;
        }

        public int hashCode() {
            return Boolean.hashCode(this.b);
        }
    }
}

