/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.lookup;

import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.text.lookup.UrlStringLookup;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class UrlStringLookupTest {
    UrlStringLookupTest() {
    }

    @Test
    void testBadCharsetName() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> UrlStringLookup.INSTANCE.apply("BAD_CHARSET_NAME:BAD_URL"));
    }

    @Test
    void testBadEncoding() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> UrlStringLookup.INSTANCE.apply("FOO:https://www.google.com"));
    }

    @Test
    void testBadUrl() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> UrlStringLookup.INSTANCE.apply("UTF-8:BAD_URL"));
    }

    @Test
    void testFileScheme() throws Exception {
        Path path = Paths.get("src/test/resources/org/apache/commons/text/document.properties", new String[0]);
        URI uri = path.toUri();
        byte[] expectedBytes = Files.readAllBytes(path);
        String expectedString = new String(expectedBytes, StandardCharsets.UTF_8);
        Assertions.assertEquals((Object)expectedString, (Object)UrlStringLookup.INSTANCE.apply("UTF-8:" + uri.toString()));
    }

    @Test
    void testHttpScheme() {
        Assertions.assertNotNull((Object)UrlStringLookup.INSTANCE.apply("UTF-8:https://www.apache.org"));
        Assertions.assertNotNull((Object)UrlStringLookup.INSTANCE.apply("UTF-8:https://www.google.com"));
    }

    @Test
    void testMissingUrl() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> UrlStringLookup.INSTANCE.apply("UTF-8"));
    }

    @Test
    void testNull() {
        Assertions.assertNull((Object)UrlStringLookup.INSTANCE.apply(null));
    }

    @Test
    void testToString() {
        Assertions.assertFalse((boolean)UrlStringLookup.INSTANCE.toString().isEmpty());
    }
}

