/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.journal.impl.dataformat;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.journal.impl.dataformat.JournalInternalRecord;
import org.apache.activemq.artemis.core.persistence.Persister;

public class JournalAddRecordTX
extends JournalInternalRecord {
    private final long txID;
    private final long id;
    protected final Persister persister;
    protected final Object record;
    private final byte recordType;
    private final boolean add;

    public JournalAddRecordTX(boolean add, long txID, long id, byte recordType, Persister persister, Object record) {
        this.txID = txID;
        this.id = id;
        this.persister = persister;
        this.record = record;
        this.recordType = recordType;
        this.add = add;
    }

    @Override
    public void encode(ActiveMQBuffer buffer) {
        if (this.add) {
            buffer.writeByte((byte)13);
        } else {
            buffer.writeByte((byte)14);
        }
        buffer.writeInt(this.fileID);
        buffer.writeByte(this.compactCount);
        buffer.writeLong(this.txID);
        buffer.writeLong(this.id);
        int persisterEncodeSize = this.persister.getEncodeSize(this.record);
        int encodeSize = this.getInternalEncodeSize(persisterEncodeSize);
        buffer.writeInt(persisterEncodeSize);
        buffer.writeByte(this.recordType);
        this.persister.encode(buffer, this.record);
        buffer.writeInt(encodeSize);
    }

    @Override
    public int getEncodeSize() {
        return this.getInternalEncodeSize(this.persister.getEncodeSize(this.record));
    }

    private int getInternalEncodeSize(int persisterEncodeSize) {
        return 30 + persisterEncodeSize + 1;
    }
}

