/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.auth.signatures;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.X509EncodedKeySpec;

public enum RSA {

    private static final String RSA = "RSA";

    public static PrivateKey privateKeyFromPKCS8(byte[] pkcs8) throws InvalidKeySpecException {
        try {
            PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(pkcs8);
            KeyFactory keyFactory = KeyFactory.getInstance(RSA);
            return keyFactory.generatePrivate(privateKeySpec);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    public static PrivateKey privateKeyFromPKCS1(byte[] pkcs1) throws InvalidKeySpecException {
        try {
            RSAPrivateCrtKeySpec privateKeySpec = org.tomitribe.auth.signatures.RSA.newRSAPrivateCrtKeySpec(pkcs1);
            KeyFactory keyFactory = KeyFactory.getInstance(RSA);
            return keyFactory.generatePrivate(privateKeySpec);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    public static PublicKey publicKeyFrom(byte[] derBytes) throws InvalidKeySpecException {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(RSA);
            X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(derBytes);
            return keyFactory.generatePublic(publicKeySpec);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    private static RSAPrivateCrtKeySpec newRSAPrivateCrtKeySpec(byte[] keyInPkcs1) throws IOException {
        DerParser parser = new DerParser(keyInPkcs1);
        Asn1Object sequence = parser.read();
        if (sequence.getType() != 16) {
            throw new IllegalArgumentException("Invalid DER: not a sequence");
        }
        DerParser p = sequence.getParser();
        p.read();
        BigInteger modulus = p.read().getInteger();
        BigInteger publicExp = p.read().getInteger();
        BigInteger privateExp = p.read().getInteger();
        BigInteger prime1 = p.read().getInteger();
        BigInteger prime2 = p.read().getInteger();
        BigInteger exp1 = p.read().getInteger();
        BigInteger exp2 = p.read().getInteger();
        BigInteger crtCoef = p.read().getInteger();
        return new RSAPrivateCrtKeySpec(modulus, publicExp, privateExp, prime1, prime2, exp1, exp2, crtCoef);
    }

    static class DerParser {
        public static final int UNIVERSAL = 0;
        public static final int APPLICATION = 64;
        public static final int CONTEXT = 128;
        public static final int PRIVATE = 192;
        public static final int CONSTRUCTED = 32;
        public static final int ANY = 0;
        public static final int BOOLEAN = 1;
        public static final int INTEGER = 2;
        public static final int BIT_STRING = 3;
        public static final int OCTET_STRING = 4;
        public static final int NULL = 5;
        public static final int OBJECT_IDENTIFIER = 6;
        public static final int REAL = 9;
        public static final int ENUMERATED = 10;
        public static final int RELATIVE_OID = 13;
        public static final int SEQUENCE = 16;
        public static final int SET = 17;
        public static final int NUMERIC_STRING = 18;
        public static final int PRINTABLE_STRING = 19;
        public static final int T61_STRING = 20;
        public static final int VIDEOTEX_STRING = 21;
        public static final int IA5_STRING = 22;
        public static final int GRAPHIC_STRING = 25;
        public static final int ISO646_STRING = 26;
        public static final int GENERAL_STRING = 27;
        public static final int UTF8_STRING = 12;
        public static final int UNIVERSAL_STRING = 28;
        public static final int BMP_STRING = 30;
        public static final int UTC_TIME = 23;
        public static final int GENERALIZED_TIME = 24;
        protected final InputStream in;

        public DerParser(InputStream in) throws IOException {
            this.in = in;
        }

        public DerParser(byte[] bytes) throws IOException {
            this(new ByteArrayInputStream(bytes));
        }

        public Asn1Object read() throws IOException {
            int tag = this.in.read();
            if (tag == -1) {
                throw new IOException("Invalid DER: stream too short, missing tag");
            }
            int length = this.getLength();
            byte[] value = new byte[length];
            int n = this.in.read(value);
            if (n < length) {
                throw new IOException("Invalid DER: stream too short, missing value");
            }
            return new Asn1Object(tag, length, value);
        }

        private int getLength() throws IOException {
            int i = this.in.read();
            if (i == -1) {
                throw new IOException("Invalid DER: length missing");
            }
            if ((i & 0xFFFFFF80) == 0) {
                return i;
            }
            int num = i & 0x7F;
            if (i >= 255 || num > 4) {
                throw new IOException("Invalid DER: length field too big (" + i + ")");
            }
            byte[] bytes = new byte[num];
            int n = this.in.read(bytes);
            if (n < num) {
                throw new IOException("Invalid DER: length too short");
            }
            return new BigInteger(1, bytes).intValue();
        }
    }

    static class Asn1Object {
        protected final int type;
        protected final int length;
        protected final byte[] value;
        protected final int tag;

        public Asn1Object(int tag, int length, byte[] value) {
            this.tag = tag;
            this.type = tag & 0x1F;
            this.length = length;
            this.value = value;
        }

        public int getType() {
            return this.type;
        }

        public int getLength() {
            return this.length;
        }

        public byte[] getValue() {
            return this.value;
        }

        public boolean isConstructed() {
            return (this.tag & 0x20) == 32;
        }

        public DerParser getParser() throws IOException {
            if (!this.isConstructed()) {
                throw new IOException("Invalid DER: can't parse primitive entity");
            }
            return new DerParser(this.value);
        }

        public BigInteger getInteger() throws IOException {
            if (this.type != 2) {
                throw new IOException("Invalid DER: object is not integer");
            }
            return new BigInteger(this.value);
        }

        public String getString() throws IOException {
            switch (this.type) {
                case 18: 
                case 19: 
                case 21: 
                case 22: 
                case 25: 
                case 26: 
                case 27: {
                    return new String(this.value, "ISO-8859-1");
                }
                case 30: {
                    return new String(this.value, "UTF-16BE");
                }
                case 12: {
                    return new String(this.value, "UTF-8");
                }
                case 28: {
                    throw new IOException("Invalid DER: can't handle UCS-4 string");
                }
            }
            throw new IOException("Invalid DER: object is not a string");
        }
    }
}

