/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.httpsignature.filters;

import jakarta.annotation.Priority;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientResponseContext;
import jakarta.ws.rs.client.ClientResponseFilter;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.Provider;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.cxf.rs.security.httpsignature.exception.SignatureException;
import org.apache.cxf.rs.security.httpsignature.filters.AbstractSignatureInFilter;

@Provider
@Priority(value=1000)
public class VerifySignatureClientFilter
extends AbstractSignatureInFilter
implements ClientResponseFilter {
    public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) {
        byte[] messageBody = this.verifyDigest((MultivaluedMap<String, String>)responseContext.getHeaders(), responseContext.getEntityStream());
        if (messageBody != null) {
            responseContext.setEntityStream((InputStream)new ByteArrayInputStream(messageBody));
        }
        this.verifySignature((MultivaluedMap<String, String>)responseContext.getHeaders(), "", "", messageBody);
    }

    @Override
    protected void handleException(Exception ex) {
        throw new SignatureException("Error verifying signature", ex);
    }
}

