/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.io;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Path;
import org.apache.daffodil.io.ByteArrayOutputStreamWithGetBuf;
import org.apache.daffodil.io.FileIOException;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.lib.util.Logger$;
import org.apache.daffodil.lib.util.Maybe$;
import scala.Function1;
import scala.Int$;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

public class ByteArrayOrFileOutputStream
extends OutputStream {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(ByteArrayOrFileOutputStream.class.getDeclaredField("isTempFile$lzy1"));
    private final long maxBufferSizeInBytes;
    private final File tempDirPath;
    private final Object maybeExistingFile;
    private boolean isFile;
    private Object maybeFile;
    private volatile Object isTempFile$lzy1;
    private long nBytes;
    private OutputStream stream;

    public ByteArrayOrFileOutputStream(long maxBufferSizeInBytes, File tempDirPath, Object maybeExistingFile) {
        this.maxBufferSizeInBytes = maxBufferSizeInBytes;
        this.tempDirPath = tempDirPath;
        this.maybeExistingFile = maybeExistingFile;
        this.isFile = Maybe$.MODULE$.isDefined$extension(maybeExistingFile);
        this.maybeFile = Maybe$.MODULE$.isDefined$extension(maybeExistingFile) ? Maybe$.MODULE$.apply(((Path)Maybe$.MODULE$.get$extension(maybeExistingFile)).toFile()) : Maybe$.MODULE$.Nope();
        this.nBytes = 0L;
        this.stream = new ByteArrayOutputStreamWithGetBuf();
    }

    public boolean isFile() {
        return this.isFile;
    }

    public void isFile_$eq(boolean x$1) {
        this.isFile = x$1;
    }

    public boolean isTempFile() {
        Object object = this.isTempFile$lzy1;
        if (object instanceof Boolean) {
            return BoxesRunTime.unboxToBoolean((Object)object);
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return BoxesRunTime.unboxToBoolean(null);
        }
        return BoxesRunTime.unboxToBoolean((Object)this.isTempFile$lzyINIT1());
    }

    private Object isTempFile$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.isTempFile$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Boolean bl = null;
                    try {
                        bl = BoxesRunTime.boxToBoolean((!Maybe$.MODULE$.isDefined$extension(this.maybeExistingFile) && this.isFile() ? 1 : 0) != 0);
                        object2 = bl == null ? LazyVals.NullValue$.MODULE$ : bl;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.isTempFile$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return bl;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public long nBytes() {
        return this.nBytes;
    }

    public void nBytes_$eq(long x$1) {
        this.nBytes = x$1;
    }

    public OutputStream stream() {
        return this.stream;
    }

    public void stream_$eq(OutputStream x$1) {
        this.stream = x$1;
    }

    private void checkBuffer(long lengthInBytes) {
        if (!this.isFile() && this.nBytes() + lengthInBytes > this.maxBufferSizeInBytes) {
            Object object;
            Logger LoggerImpl_this = Logger$.MODULE$.log();
            if (LoggerImpl_this.underlying().isWarnEnabled()) {
                LoggerImpl_this.underlying().warn("Switching to file based output stream. If this is performance critical, you may want to consider re-organizing your schema to avoid this if possible.");
            }
            ByteArrayOrFileOutputStream byteArrayOrFileOutputStream = this;
            try {
                File file = File.createTempFile("daffodil-", ".tmp", this.tempDirPath);
                file.deleteOnExit();
                object = Maybe$.MODULE$.apply(file);
            }
            catch (Exception e) {
                throw new FileIOException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Unable to create temporary file in %s: %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.tempDirPath.getPath(), e.getMessage()})));
            }
            Object object2 = object;
            ByteArrayOrFileOutputStream byteArrayOrFileOutputStream2 = byteArrayOrFileOutputStream;
            byteArrayOrFileOutputStream = null;
            Object object3 = object2;
            object2 = null;
            byteArrayOrFileOutputStream2.maybeFile = object3;
            Object object4 = this.maybeFile;
            FileOutputStream newStream = new FileOutputStream((File)Maybe$.MODULE$.get$extension(object4));
            this.stream().flush();
            ((ByteArrayOutputStreamWithGetBuf)this.stream()).writeTo(newStream);
            this.stream_$eq(newStream);
            this.isFile_$eq(true);
            return;
        }
        this.nBytes_$eq(this.nBytes() + lengthInBytes);
    }

    @Override
    public void write(byte[] b) {
        this.checkBuffer(Int$.MODULE$.int2long(b.length));
        this.stream().write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        this.checkBuffer(Int$.MODULE$.int2long(len));
        this.stream().write(b, off, len);
    }

    @Override
    public void write(int b) {
        this.checkBuffer(1L);
        this.stream().write(b);
    }

    @Override
    public void close() {
        this.stream().close();
    }

    public byte[] getBuf() {
        if (this.isFile()) {
            throw Assert$.MODULE$.usageError2("Attempted to call getBuf on FileOutputStream", "ByteArrayOrFileOutputStream.this.isFile.unary_!");
        }
        return ((ByteArrayOutputStreamWithGetBuf)this.stream()).getBuf();
    }

    public File getFile() {
        Object object = this.maybeFile;
        return (File)Maybe$.MODULE$.get$extension(object);
    }

    private String hexDump() {
        if (this.isFile()) {
            Object object = this.maybeFile;
            return ((File)Maybe$.MODULE$.get$extension(object)).toString();
        }
        return RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), (int)this.nBytes()).map((Function1 & Serializable)i -> this.hexDump$$anonfun$1(BoxesRunTime.unboxToInt((Object)i))).mkString(".");
    }

    public String toString() {
        return this.hexDump();
    }

    private final /* synthetic */ String hexDump$$anonfun$1(int i) {
        return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%2x"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(this.getBuf()[i] & 0xFF))}));
    }
}

