/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hll;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import org.apache.datasketches.common.SketchesStateException;
import org.apache.datasketches.hll.CouponList;
import org.apache.datasketches.hll.CurMode;
import org.apache.datasketches.hll.HllSketchImpl;
import org.apache.datasketches.hll.PreambleUtil;
import org.apache.datasketches.hll.TgtHllType;

final class CouponHashSet
extends CouponList {
    CouponHashSet(int lgConfigK, TgtHllType tgtHllType) {
        super(lgConfigK, tgtHllType, CurMode.SET);
        assert (lgConfigK > 7);
    }

    CouponHashSet(CouponHashSet that) {
        super(that);
    }

    CouponHashSet(CouponHashSet that, TgtHllType tgtHllType) {
        super(that, tgtHllType);
    }

    static CouponHashSet heapifySet(MemorySegment seg) {
        int lgConfigK = PreambleUtil.extractLgK(seg);
        TgtHllType tgtHllType = PreambleUtil.extractTgtHllType(seg);
        CurMode curMode = PreambleUtil.extractCurMode(seg);
        int segArrStart = curMode == CurMode.LIST ? PreambleUtil.LIST_INT_ARR_START : PreambleUtil.HASH_SET_INT_ARR_START;
        CouponHashSet set = new CouponHashSet(lgConfigK, tgtHllType);
        boolean segIsCompact = PreambleUtil.extractCompactFlag(seg);
        int couponCount = PreambleUtil.extractHashSetCount(seg);
        int lgCouponArrInts = PreambleUtil.extractLgArr(seg);
        if (lgCouponArrInts < 5) {
            lgCouponArrInts = PreambleUtil.computeLgArr(seg, couponCount, lgConfigK);
        }
        if (segIsCompact) {
            for (int i = 0; i < couponCount; ++i) {
                set.couponUpdate(PreambleUtil.extractInt(seg, segArrStart + (i << 2)));
            }
        } else {
            set.couponCount = couponCount;
            set.lgCouponArrInts = lgCouponArrInts;
            int couponArrInts = 1 << lgCouponArrInts;
            set.couponIntArr = new int[couponArrInts];
            MemorySegment.copy(seg, ValueLayout.JAVA_INT_UNALIGNED, PreambleUtil.HASH_SET_INT_ARR_START, set.couponIntArr, 0, couponArrInts);
        }
        return set;
    }

    @Override
    CouponHashSet copy() {
        return new CouponHashSet(this);
    }

    @Override
    CouponHashSet copyAs(TgtHllType tgtHllType) {
        return new CouponHashSet(this, tgtHllType);
    }

    @Override
    HllSketchImpl couponUpdate(int coupon) {
        int index = CouponHashSet.find(this.couponIntArr, this.lgCouponArrInts, coupon);
        if (index >= 0) {
            return this;
        }
        this.couponIntArr[index ^ 0xFFFFFFFF] = coupon;
        ++this.couponCount;
        if (this.checkGrowOrPromote()) {
            return CouponHashSet.promoteHeapListOrSetToHll(this);
        }
        return this;
    }

    @Override
    int getSegDataStart() {
        return PreambleUtil.HASH_SET_INT_ARR_START;
    }

    @Override
    int getPreInts() {
        return 3;
    }

    private boolean checkGrowOrPromote() {
        if (4 * this.couponCount > 3 * (1 << this.lgCouponArrInts)) {
            if (this.lgCouponArrInts == this.lgConfigK - 3) {
                return true;
            }
            this.couponIntArr = CouponHashSet.growHashSet(this.couponIntArr, ++this.lgCouponArrInts);
        }
        return false;
    }

    private static int[] growHashSet(int[] coupIntArr, int tgtLgCoupArrSize) {
        int[] tgtCouponIntArr = new int[1 << tgtLgCoupArrSize];
        for (int fetched : coupIntArr) {
            if (fetched == 0) continue;
            int idx = CouponHashSet.find(tgtCouponIntArr, tgtLgCoupArrSize, fetched);
            if (idx < 0) {
                tgtCouponIntArr[idx ^ 0xFFFFFFFF] = fetched;
                continue;
            }
            throw new SketchesStateException("Error: found duplicate.");
        }
        return tgtCouponIntArr;
    }
}

