/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.metadata.metadata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.metadata.metadata.ColumnAnalysis;
import org.joda.time.Interval;

public class SegmentAnalysis
implements Comparable<SegmentAnalysis> {
    private final String id;
    private final List<Interval> interval;
    private final LinkedHashMap<String, ColumnAnalysis> columns;
    private final long size;
    private final long numRows;
    private final Map<String, AggregatorFactory> aggregators;
    private final TimestampSpec timestampSpec;
    private final Granularity queryGranularity;
    private final Boolean rollup;

    @JsonCreator
    public SegmentAnalysis(@JsonProperty(value="id") String id, @JsonProperty(value="intervals") List<Interval> interval, @JsonProperty(value="columns") LinkedHashMap<String, ColumnAnalysis> columns, @JsonProperty(value="size") long size, @JsonProperty(value="numRows") long numRows, @JsonProperty(value="aggregators") Map<String, AggregatorFactory> aggregators, @JsonProperty(value="timestampSpec") TimestampSpec timestampSpec, @JsonProperty(value="queryGranularity") Granularity queryGranularity, @JsonProperty(value="rollup") Boolean rollup) {
        this.id = id;
        this.interval = interval;
        this.columns = columns;
        this.size = size;
        this.numRows = numRows;
        this.aggregators = aggregators;
        this.timestampSpec = timestampSpec;
        this.queryGranularity = queryGranularity;
        this.rollup = rollup;
    }

    @JsonProperty
    public String getId() {
        return this.id;
    }

    @JsonProperty
    public List<Interval> getIntervals() {
        return this.interval;
    }

    @JsonProperty
    public LinkedHashMap<String, ColumnAnalysis> getColumns() {
        return this.columns;
    }

    @JsonProperty
    public long getSize() {
        return this.size;
    }

    @JsonProperty
    public long getNumRows() {
        return this.numRows;
    }

    @JsonProperty
    public TimestampSpec getTimestampSpec() {
        return this.timestampSpec;
    }

    @JsonProperty
    public Granularity getQueryGranularity() {
        return this.queryGranularity;
    }

    @JsonProperty
    public Boolean isRollup() {
        return this.rollup;
    }

    @JsonProperty
    public Map<String, AggregatorFactory> getAggregators() {
        return this.aggregators;
    }

    public String toString() {
        return "SegmentAnalysis{id='" + this.id + "', interval=" + String.valueOf(this.interval) + ", columns=" + String.valueOf(this.columns) + ", size=" + this.size + ", numRows=" + this.numRows + ", aggregators=" + String.valueOf(this.aggregators) + ", timestampSpec=" + String.valueOf(this.timestampSpec) + ", queryGranularity=" + String.valueOf(this.queryGranularity) + ", rollup=" + this.rollup + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SegmentAnalysis that = (SegmentAnalysis)o;
        return this.size == that.size && this.numRows == that.numRows && Objects.equals(this.rollup, that.rollup) && Objects.equals(this.id, that.id) && Objects.equals(this.interval, that.interval) && Objects.equals(this.columns, that.columns) && Objects.equals(this.aggregators, that.aggregators) && Objects.equals(this.timestampSpec, that.timestampSpec) && Objects.equals(this.queryGranularity, that.queryGranularity);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.interval, this.columns, this.size, this.numRows, this.aggregators, this.timestampSpec, this.queryGranularity, this.rollup);
    }

    @Override
    public int compareTo(SegmentAnalysis rhs) {
        return this.id.compareTo(rhs.getId());
    }
}

