/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing.error;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Objects;
import org.apache.druid.msq.indexing.error.BaseMSQFault;

@JsonTypeName(value="TooManyBuckets")
public class TooManyBucketsFault
extends BaseMSQFault {
    static final String CODE = "TooManyBuckets";
    private final int maxBuckets;

    @JsonCreator
    public TooManyBucketsFault(@JsonProperty(value="maxBuckets") int maxBuckets) {
        super(CODE, "Too many partition buckets (max = %,d); try breaking your query up into smaller queries or using a wider PARTITIONED BY", maxBuckets, new Object[0]);
        this.maxBuckets = maxBuckets;
    }

    @JsonProperty
    public int getMaxBuckets() {
        return this.maxBuckets;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TooManyBucketsFault that = (TooManyBucketsFault)o;
        return this.maxBuckets == that.maxBuckets;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.maxBuckets);
    }
}

