/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.querykit;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.planning.DataSourceAnalysis;
import org.apache.druid.query.policy.Policy;
import org.apache.druid.segment.RestrictedSegment;
import org.apache.druid.segment.SegmentReference;

@JsonTypeName(value="restrictedInputNumber")
public class RestrictedInputNumberDataSource
implements DataSource {
    private final int inputNumber;
    private final Policy policy;

    @JsonCreator
    public RestrictedInputNumberDataSource(@JsonProperty(value="inputNumber") int inputNumber, @JsonProperty(value="policy") Policy policy) {
        this.inputNumber = inputNumber;
        this.policy = (Policy)Preconditions.checkNotNull((Object)policy, (Object)"Policy can't be null");
    }

    @JsonProperty
    public int getInputNumber() {
        return this.inputNumber;
    }

    @JsonProperty
    public Policy getPolicy() {
        return this.policy;
    }

    public Set<String> getTableNames() {
        return Collections.emptySet();
    }

    public List<DataSource> getChildren() {
        return Collections.emptyList();
    }

    public DataSource withChildren(List<DataSource> children) {
        if (!children.isEmpty()) {
            throw new IAE("Cannot accept children", new Object[0]);
        }
        return this;
    }

    public boolean isCacheable(boolean isBroker) {
        return false;
    }

    public boolean isGlobal() {
        return false;
    }

    public boolean isConcrete() {
        return true;
    }

    public Function<SegmentReference, SegmentReference> createSegmentMapFunction(Query query) {
        return baseSegment -> new RestrictedSegment(baseSegment, this.policy);
    }

    public DataSource withUpdatedDataSource(DataSource newSource) {
        return newSource;
    }

    public byte[] getCacheKey() {
        return null;
    }

    public DataSourceAnalysis getAnalysis() {
        return new DataSourceAnalysis((DataSource)this, null, null, Collections.emptyList(), null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RestrictedInputNumberDataSource that = (RestrictedInputNumberDataSource)o;
        return this.inputNumber == that.inputNumber && this.policy.equals(that.policy);
    }

    public int hashCode() {
        return Objects.hash(this.inputNumber, this.policy);
    }

    public String toString() {
        return "RestrictedInputNumberDataSource{inputNumber=" + this.inputNumber + ", policy=" + String.valueOf(this.policy) + "}";
    }
}

