/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.querykit.results;

import com.fasterxml.jackson.databind.ObjectMapper;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.druid.error.DruidException;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.channel.ReadableFrameChannel;
import org.apache.druid.frame.channel.WritableFrameChannel;
import org.apache.druid.frame.processor.FrameProcessor;
import org.apache.druid.frame.processor.FrameProcessors;
import org.apache.druid.frame.processor.ReturnOrAwait;
import org.apache.druid.frame.read.FrameReader;
import org.apache.druid.frame.segment.FrameSegment;
import org.apache.druid.msq.counters.ChannelCounters;
import org.apache.druid.msq.exec.ResultsContext;
import org.apache.druid.segment.BaseObjectColumnValueSelector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.CursorBuildSpec;
import org.apache.druid.segment.CursorHolder;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.planner.ColumnMapping;
import org.apache.druid.sql.calcite.planner.ColumnMappings;
import org.apache.druid.sql.calcite.run.SqlResults;
import org.apache.druid.sql.http.ResultFormat;
import org.apache.druid.storage.StorageConnector;
import org.apache.druid.timeline.SegmentId;

public class ExportResultsFrameProcessor
implements FrameProcessor<Object> {
    private final ReadableFrameChannel inputChannel;
    private final ResultFormat exportFormat;
    private final FrameReader frameReader;
    private final StorageConnector storageConnector;
    private final ObjectMapper jsonMapper;
    private final ChannelCounters channelCounter;
    private final String exportFilePath;
    private final Object2IntMap<String> outputColumnNameToFrameColumnNumberMap;
    private final RowSignature exportRowSignature;
    private final ResultsContext resultsContext;
    private final int partitionNum;
    private volatile ResultFormat.Writer exportWriter;

    public ExportResultsFrameProcessor(ReadableFrameChannel inputChannel, ResultFormat exportFormat, FrameReader frameReader, StorageConnector storageConnector, ObjectMapper jsonMapper, ChannelCounters channelCounter, String exportFilePath, ColumnMappings columnMappings, ResultsContext resultsContext, int partitionNum) {
        this.inputChannel = inputChannel;
        this.exportFormat = exportFormat;
        this.frameReader = frameReader;
        this.storageConnector = storageConnector;
        this.jsonMapper = jsonMapper;
        this.channelCounter = channelCounter;
        this.exportFilePath = exportFilePath;
        this.resultsContext = resultsContext;
        this.partitionNum = partitionNum;
        this.outputColumnNameToFrameColumnNumberMap = new Object2IntOpenHashMap();
        RowSignature inputRowSignature = frameReader.signature();
        if (columnMappings == null) {
            throw DruidException.forPersona((DruidException.Persona)DruidException.Persona.OPERATOR).ofCategory(DruidException.Category.RUNTIME_FAILURE).build("Received null columnMappings from controller. This might be due to an upgrade.", new Object[0]);
        }
        for (ColumnMapping columnMapping : columnMappings.getMappings()) {
            this.outputColumnNameToFrameColumnNumberMap.put((Object)columnMapping.getOutputColumn(), frameReader.signature().indexOf(columnMapping.getQueryColumn()));
        }
        RowSignature.Builder exportRowSignatureBuilder = RowSignature.builder();
        for (String outputColumn : columnMappings.getOutputColumnNames()) {
            exportRowSignatureBuilder.add(outputColumn, (ColumnType)inputRowSignature.getColumnType(this.outputColumnNameToFrameColumnNumberMap.getInt((Object)outputColumn)).orElse(null));
        }
        this.exportRowSignature = exportRowSignatureBuilder.build();
    }

    public List<ReadableFrameChannel> inputChannels() {
        return Collections.singletonList(this.inputChannel);
    }

    public List<WritableFrameChannel> outputChannels() {
        return Collections.emptyList();
    }

    public ReturnOrAwait<Object> runIncrementally(IntSet readableInputs) throws IOException {
        if (readableInputs.isEmpty()) {
            return ReturnOrAwait.awaitAll((int)1);
        }
        if (this.exportWriter == null) {
            this.createExportWriter();
        }
        if (this.inputChannel.isFinished()) {
            this.exportWriter.writeResponseEnd();
            return ReturnOrAwait.returnObject((Object)this.exportFilePath);
        }
        this.exportFrame(this.inputChannel.read());
        return ReturnOrAwait.awaitAll((int)1);
    }

    private void exportFrame(Frame frame) {
        FrameSegment segment = new FrameSegment(frame, this.frameReader, SegmentId.dummy((String)"test"));
        try (CursorHolder cursorHolder = segment.asCursorFactory().makeCursorHolder(CursorBuildSpec.FULL_SCAN);){
            Cursor cursor = cursorHolder.asCursor();
            if (cursor == null) {
                this.exportWriter.writeRowEnd();
                return;
            }
            ColumnSelectorFactory columnSelectorFactory = cursor.getColumnSelectorFactory();
            List selectors = this.frameReader.signature().getColumnNames().stream().map(arg_0 -> ((ColumnSelectorFactory)columnSelectorFactory).makeColumnValueSelector(arg_0)).collect(Collectors.toList());
            while (!cursor.isDone()) {
                this.exportWriter.writeRowStart();
                for (int j = 0; j < this.exportRowSignature.size(); ++j) {
                    String columnName = this.exportRowSignature.getColumnName(j);
                    BaseObjectColumnValueSelector selector = (BaseObjectColumnValueSelector)selectors.get(this.outputColumnNameToFrameColumnNumberMap.getInt((Object)columnName));
                    if (this.resultsContext == null) {
                        throw DruidException.forPersona((DruidException.Persona)DruidException.Persona.OPERATOR).ofCategory(DruidException.Category.RUNTIME_FAILURE).build("Received null resultsContext from the controller. This is due to a version mismatch between the controller and the worker. Please ensure that the worker and the controller are on the same version before retrying the query.", new Object[0]);
                    }
                    this.exportWriter.writeRowField(columnName, SqlResults.coerce((ObjectMapper)this.jsonMapper, (SqlResults.Context)this.resultsContext.getSqlResultsContext(), (Object)selector.getObject(), (SqlTypeName)this.resultsContext.getSqlTypeNames().get(j), (String)columnName));
                }
                this.channelCounter.incrementRowCount(this.partitionNum);
                this.exportWriter.writeRowEnd();
                cursor.advance();
            }
        }
        catch (IOException e) {
            throw DruidException.forPersona((DruidException.Persona)DruidException.Persona.USER).ofCategory(DruidException.Category.RUNTIME_FAILURE).build((Throwable)e, "Exception occurred while writing file to the export location [%s].", new Object[]{this.exportFilePath});
        }
    }

    private void createExportWriter() throws IOException {
        OutputStream stream = null;
        try {
            stream = this.storageConnector.write(this.exportFilePath);
            this.exportWriter = this.exportFormat.createFormatter(stream, this.jsonMapper);
            this.exportWriter.writeResponseStart();
            this.exportWriter.writeHeaderFromRowSignature(this.exportRowSignature, false);
        }
        catch (IOException e) {
            if (this.exportWriter != null) {
                this.exportWriter.close();
            }
            if (stream != null) {
                stream.close();
            }
            throw DruidException.forPersona((DruidException.Persona)DruidException.Persona.USER).ofCategory(DruidException.Category.RUNTIME_FAILURE).build((Throwable)e, "Exception occurred while opening a stream to the export location [%s].", new Object[]{this.exportFilePath});
        }
    }

    public void cleanup() throws IOException {
        FrameProcessors.closeAll(this.inputChannels(), this.outputChannels(), (Closeable[])new Closeable[0]);
        if (this.exportWriter != null) {
            this.exportWriter.close();
        }
    }
}

