/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.rule;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.logical.LogicalValues;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.druid.error.InvalidSqlInput;
import org.apache.druid.query.InlineDataSource;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.rel.DruidQueryRel;
import org.apache.druid.sql.calcite.table.RowSignatures;

public class DruidLogicalValuesRule
extends RelOptRule {
    private final PlannerContext plannerContext;

    public DruidLogicalValuesRule(PlannerContext plannerContext) {
        super(DruidLogicalValuesRule.operand(LogicalValues.class, (RelOptRuleOperandChildren)DruidLogicalValuesRule.any()));
        this.plannerContext = plannerContext;
    }

    public void onMatch(RelOptRuleCall call) {
        LogicalValues values = (LogicalValues)call.rel(0);
        ImmutableList tuples = values.getTuples();
        List objectTuples = tuples.stream().map(tuple -> tuple.stream().map(v -> DruidLogicalValuesRule.getValueFromLiteral(v, this.plannerContext)).collect(Collectors.toList()).toArray(new Object[0])).collect(Collectors.toList());
        RowSignature rowSignature = RowSignatures.fromRelDataType(values.getRowType().getFieldNames(), values.getRowType());
        call.transformTo((RelNode)DruidQueryRel.scanConstantRel((RelNode)values, InlineDataSource.fromIterable(objectTuples, (RowSignature)rowSignature), this.plannerContext));
    }

    @Nullable
    @VisibleForTesting
    public static Object getValueFromLiteral(RexLiteral literal, PlannerContext plannerContext) {
        switch (literal.getType().getSqlTypeName()) {
            case CHAR: 
            case VARCHAR: {
                return literal.getValueAs(String.class);
            }
            case FLOAT: {
                if (literal.isNull()) {
                    return null;
                }
                return Float.valueOf(((Number)((Object)RexLiteral.value((RexNode)literal))).floatValue());
            }
            case DOUBLE: 
            case REAL: 
            case DECIMAL: {
                if (literal.isNull()) {
                    return null;
                }
                return ((Number)((Object)RexLiteral.value((RexNode)literal))).doubleValue();
            }
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: {
                if (literal.isNull()) {
                    return null;
                }
                return ((Number)((Object)RexLiteral.value((RexNode)literal))).longValue();
            }
            case BOOLEAN: {
                if (literal.isNull()) {
                    return null;
                }
                return literal.isAlwaysTrue() ? 1L : 0L;
            }
            case TIMESTAMP: 
            case DATE: {
                return Calcites.calciteDateTimeLiteralToJoda((RexNode)literal, plannerContext.getTimeZone()).getMillis();
            }
            case NULL: {
                if (!literal.isNull()) {
                    throw InvalidSqlInput.exception((String)"Expected a NULL literal, but got non-null constant [%s]", (Object[])new Object[]{literal});
                }
                return null;
            }
        }
        throw InvalidSqlInput.exception((String)"Cannot handle literal [%s] of unsupported type [%s].", (Object[])new Object[]{literal, literal.getType().getSqlTypeName()});
    }
}

