/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client.indexing;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.client.indexing.IndexingWorker;
import org.joda.time.DateTime;

public class IndexingWorkerInfo {
    private final IndexingWorker worker;
    private final int currCapacityUsed;
    private final Set<String> availabilityGroups;
    private final Collection<String> runningTasks;
    private final DateTime lastCompletedTaskTime;
    private final DateTime blacklistedUntil;

    @JsonCreator
    public IndexingWorkerInfo(@JsonProperty(value="worker") IndexingWorker worker, @JsonProperty(value="currCapacityUsed") int currCapacityUsed, @JsonProperty(value="availabilityGroups") Set<String> availabilityGroups, @JsonProperty(value="runningTasks") Collection<String> runningTasks, @JsonProperty(value="lastCompletedTaskTime") DateTime lastCompletedTaskTime, @JsonProperty(value="blacklistedUntil") @Nullable DateTime blacklistedUntil) {
        this.worker = worker;
        this.currCapacityUsed = currCapacityUsed;
        this.availabilityGroups = availabilityGroups;
        this.runningTasks = runningTasks;
        this.lastCompletedTaskTime = lastCompletedTaskTime;
        this.blacklistedUntil = blacklistedUntil;
    }

    @JsonProperty(value="worker")
    public IndexingWorker getWorker() {
        return this.worker;
    }

    @JsonProperty(value="currCapacityUsed")
    public int getCurrCapacityUsed() {
        return this.currCapacityUsed;
    }

    @JsonProperty(value="availabilityGroups")
    public Set<String> getAvailabilityGroups() {
        return this.availabilityGroups;
    }

    @JsonProperty(value="runningTasks")
    public Collection<String> getRunningTasks() {
        return this.runningTasks;
    }

    @JsonProperty(value="lastCompletedTaskTime")
    public DateTime getLastCompletedTaskTime() {
        return this.lastCompletedTaskTime;
    }

    @JsonProperty
    public DateTime getBlacklistedUntil() {
        return this.blacklistedUntil;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexingWorkerInfo that = (IndexingWorkerInfo)o;
        return this.currCapacityUsed == that.currCapacityUsed && Objects.equals(this.worker, that.worker) && Objects.equals(this.availabilityGroups, that.availabilityGroups) && Objects.equals(this.runningTasks, that.runningTasks) && Objects.equals(this.lastCompletedTaskTime, that.lastCompletedTaskTime) && Objects.equals(this.blacklistedUntil, that.blacklistedUntil);
    }

    public int hashCode() {
        return Objects.hash(this.worker, this.currCapacityUsed, this.availabilityGroups, this.runningTasks, this.lastCompletedTaskTime, this.blacklistedUntil);
    }

    public String toString() {
        return "IndexingWorkerInfo{worker=" + String.valueOf(this.worker) + ", currCapacityUsed=" + this.currCapacityUsed + ", availabilityGroups=" + String.valueOf(this.availabilityGroups) + ", runningTasks=" + String.valueOf(this.runningTasks) + ", lastCompletedTaskTime=" + String.valueOf(this.lastCompletedTaskTime) + ", blacklistedUntil=" + String.valueOf(this.blacklistedUntil) + "}";
    }
}

