/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server;

import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.context.ResponseContext;

public class QuerySwappingQueryRunner<T>
implements QueryRunner<T> {
    private final QueryRunner<T> baseRunner;
    private final Query<T> query;
    private final Query<T> newQuery;

    public QuerySwappingQueryRunner(QueryRunner<T> baseRunner, Query<T> query, Query<T> newQuery) {
        this.baseRunner = baseRunner;
        this.query = query;
        this.newQuery = newQuery;
    }

    public Sequence<T> run(QueryPlus<T> queryPlus, ResponseContext responseContext) {
        if (queryPlus.getQuery() != this.query) {
            throw DruidException.defensive((String)"Unexpected query received", (Object[])new Object[0]);
        }
        return this.baseRunner.run(queryPlus.withQuery(this.newQuery), responseContext);
    }
}

