/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.apache.druid.common.config.Configs;
import org.joda.time.Duration;

public class MetadataCleanupConfig {
    public static final MetadataCleanupConfig DEFAULT = new MetadataCleanupConfig(null, null, null);
    @JsonProperty(value="on")
    private final boolean cleanupEnabled;
    @JsonProperty(value="period")
    private final Duration cleanupPeriod;
    @JsonProperty(value="durationToRetain")
    private final Duration durationToRetain;

    @JsonCreator
    public MetadataCleanupConfig(@JsonProperty(value="on") Boolean cleanupEnabled, @JsonProperty(value="period") Duration cleanupPeriod, @JsonProperty(value="durationToRetain") Duration durationToRetain) {
        this.cleanupEnabled = Configs.valueOrDefault((Boolean)cleanupEnabled, (boolean)true);
        this.cleanupPeriod = (Duration)Configs.valueOrDefault((Object)cleanupPeriod, (Object)Duration.standardDays((long)1L));
        this.durationToRetain = (Duration)Configs.valueOrDefault((Object)durationToRetain, (Object)Duration.standardDays((long)90L));
    }

    public Duration getCleanupPeriod() {
        return this.cleanupPeriod;
    }

    public Duration getDurationToRetain() {
        return this.durationToRetain;
    }

    public boolean isCleanupEnabled() {
        return this.cleanupEnabled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetadataCleanupConfig that = (MetadataCleanupConfig)o;
        return this.cleanupEnabled == that.cleanupEnabled && Objects.equals(this.cleanupPeriod, that.cleanupPeriod) && Objects.equals(this.durationToRetain, that.durationToRetain);
    }

    public int hashCode() {
        return Objects.hash(this.cleanupEnabled, this.cleanupPeriod, this.durationToRetain);
    }
}

