/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.metrics;

import java.util.function.ObjIntConsumer;
import org.apache.druid.java.util.emitter.EmittingLogger;

public class SegmentRowCountDistribution {
    private static final EmittingLogger log = new EmittingLogger(SegmentRowCountDistribution.class);
    private final int[] buckets = new int[9];
    private static final int TOMBSTONE_BUCKET_INDEX = 0;

    public void addRowCountToDistribution(long rowCount) {
        int bucketIndex;
        int n = bucketIndex = SegmentRowCountDistribution.determineBucketFromRowCount(rowCount);
        this.buckets[n] = this.buckets[n] + 1;
    }

    public void removeRowCountFromDistribution(long rowCount) {
        int bucketIndex;
        int n = bucketIndex = SegmentRowCountDistribution.determineBucketFromRowCount(rowCount);
        this.buckets[n] = this.buckets[n] - 1;
        if (this.buckets[bucketIndex] < 0) {
            log.error("somehow got a count of less than 0, resetting value to 0", new Object[0]);
            this.buckets[bucketIndex] = 0;
        }
    }

    public void addTombstoneToDistribution() {
        this.buckets[0] = this.buckets[0] + 1;
    }

    public void removeTombstoneFromDistribution() {
        this.buckets[0] = this.buckets[0] - 1;
    }

    private static String getBucketDimensionFromIndex(int index) {
        switch (index) {
            case 0: {
                return "Tombstone";
            }
            case 1: {
                return "0";
            }
            case 2: {
                return "1-10k";
            }
            case 3: {
                return "10k-2M";
            }
            case 4: {
                return "2M-4M";
            }
            case 5: {
                return "4M-6M";
            }
            case 6: {
                return "6M-8M";
            }
            case 7: {
                return "8M-10M";
            }
            case 8: {
                return "10M+";
            }
        }
        return "NA";
    }

    private static int determineBucketFromRowCount(long rowCount) {
        if (rowCount <= 0L) {
            return 1;
        }
        if (rowCount <= 10000L) {
            return 2;
        }
        if (rowCount <= 2000000L) {
            return 3;
        }
        if (rowCount <= 4000000L) {
            return 4;
        }
        if (rowCount <= 6000000L) {
            return 5;
        }
        if (rowCount <= 8000000L) {
            return 6;
        }
        if (rowCount <= 10000000L) {
            return 7;
        }
        return 8;
    }

    public void forEachDimension(ObjIntConsumer<String> consumer) {
        for (int ii = 0; ii < this.buckets.length; ++ii) {
            if (ii <= 1 && this.buckets[ii] == 0) continue;
            consumer.accept(SegmentRowCountDistribution.getBucketDimensionFromIndex(ii), this.buckets[ii]);
        }
    }
}

