/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.avro;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.druid.data.input.avro.AvroParseSpec;
import org.apache.druid.data.input.impl.ParseSpec;
import org.apache.druid.indexer.HadoopDruidIndexerConfig;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.parquet.avro.AvroDataSupplier;
import org.apache.parquet.avro.AvroReadSupport;
import org.apache.parquet.avro.AvroRecordMaterializer;
import org.apache.parquet.avro.AvroSchemaConverter;
import org.apache.parquet.avro.SpecificDataSupplier;
import org.apache.parquet.hadoop.api.InitContext;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.io.api.RecordMaterializer;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.Type;

public class DruidParquetAvroReadSupport
extends AvroReadSupport<GenericRecord> {
    private MessageType getPartialReadSchema(InitContext context) {
        MessageType fullSchema = context.getFileSchema();
        String name = fullSchema.getName();
        HadoopDruidIndexerConfig config = HadoopDruidIndexerConfig.fromConfiguration((Configuration)context.getConfiguration());
        ParseSpec parseSpec = config.getParser().getParseSpec();
        if (parseSpec instanceof AvroParseSpec && ((AvroParseSpec)parseSpec).getFlattenSpec() != null) {
            return fullSchema;
        }
        String tsField = config.getParser().getParseSpec().getTimestampSpec().getTimestampColumn();
        List dimensionSchema = config.getParser().getParseSpec().getDimensionsSpec().getDimensions();
        HashSet<String> dimensions = new HashSet<String>();
        for (AggregatorFactory[] dim : dimensionSchema) {
            dimensions.add(dim.getName());
        }
        HashSet metricsFields = new HashSet();
        for (AggregatorFactory agg : config.getSchema().getDataSchema().getAggregators()) {
            metricsFields.addAll(agg.requiredFields());
        }
        ArrayList<Type> partialFields = new ArrayList<Type>();
        for (Type type : fullSchema.getFields()) {
            if (!tsField.equals(type.getName()) && !metricsFields.contains(type.getName()) && (dimensions.size() <= 0 || !dimensions.contains(type.getName())) && dimensions.size() != 0) continue;
            partialFields.add(type);
        }
        return new MessageType(name, partialFields);
    }

    public ReadSupport.ReadContext init(InitContext context) {
        MessageType requestedProjection = DruidParquetAvroReadSupport.getSchemaForRead((MessageType)context.getFileSchema(), (MessageType)this.getPartialReadSchema(context));
        return new ReadSupport.ReadContext(requestedProjection);
    }

    public RecordMaterializer<GenericRecord> prepareForRead(Configuration configuration, Map<String, String> keyValueMetaData, MessageType fileSchema, ReadSupport.ReadContext readContext) {
        String jobProp = "parquet.avro.add-list-element-records";
        Boolean explicitlySet = configuration.getBoolean(jobProp, false);
        if (!explicitlySet.booleanValue()) {
            configuration.setBoolean(jobProp, false);
        }
        MessageType parquetSchema = readContext.getRequestedSchema();
        Schema avroSchema = new AvroSchemaConverter(configuration).convert(parquetSchema);
        Class suppClass = configuration.getClass("parquet.avro.data.supplier", SpecificDataSupplier.class, AvroDataSupplier.class);
        AvroDataSupplier supplier = (AvroDataSupplier)ReflectionUtils.newInstance((Class)suppClass, (Configuration)configuration);
        return new AvroRecordMaterializer(parquetSchema, avroSchema, supplier.get());
    }
}

