/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexer;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.indexer.DataSegmentAndIndexZipFilePath;
import org.apache.druid.indexer.HadoopDruidIndexerConfig;
import org.apache.druid.indexer.IndexGeneratorJob;
import org.apache.druid.indexer.JobHelper;
import org.apache.druid.indexer.Jobby;
import org.apache.druid.indexer.MetadataStorageUpdaterJob;
import org.apache.druid.indexer.path.SegmentMetadataPublisher;
import org.apache.druid.java.util.common.logger.Logger;

public class HadoopDruidIndexerJob
implements Jobby {
    private static final Logger log = new Logger(HadoopDruidIndexerJob.class);
    private final HadoopDruidIndexerConfig config;
    @Nullable
    private final MetadataStorageUpdaterJob metadataStorageUpdaterJob;
    @Nullable
    private IndexGeneratorJob indexJob;
    @Nullable
    private volatile List<DataSegmentAndIndexZipFilePath> publishedSegmentAndIndexZipFilePaths = null;
    @Nullable
    private String hadoopJobIdFile;

    @Inject
    public HadoopDruidIndexerJob(HadoopDruidIndexerConfig config, SegmentMetadataPublisher handler) {
        config.verify();
        this.config = config;
        Preconditions.checkArgument((!config.isUpdaterJobSpecSet() || handler != null ? 1 : 0) != 0, (Object)"MetadataStorageUpdaterJobHandler must not be null if ioConfig.metadataUpdateSpec is specified.");
        this.metadataStorageUpdaterJob = config.isUpdaterJobSpecSet() ? new MetadataStorageUpdaterJob(config, handler) : null;
    }

    public boolean run() {
        ArrayList<Jobby> jobs = new ArrayList<Jobby>();
        JobHelper.ensurePaths(this.config);
        this.indexJob = new IndexGeneratorJob(this.config);
        jobs.add(this.indexJob);
        if (this.metadataStorageUpdaterJob != null) {
            jobs.add(this.metadataStorageUpdaterJob);
        } else {
            log.info("No metadataStorageUpdaterJob set in the config. This is cool if you are running a hadoop index task, otherwise nothing will be uploaded to database.", new Object[0]);
        }
        jobs.add(() -> {
            this.publishedSegmentAndIndexZipFilePaths = IndexGeneratorJob.getPublishedSegmentAndIndexZipFilePaths(this.config);
            return true;
        });
        this.config.setHadoopJobIdFileName(this.hadoopJobIdFile);
        return JobHelper.runJobs(jobs);
    }

    public Map<String, Object> getStats() {
        if (this.indexJob == null) {
            return null;
        }
        return this.indexJob.getStats();
    }

    @Nullable
    public String getErrorMessage() {
        if (this.indexJob == null) {
            return null;
        }
        return this.indexJob.getErrorMessage();
    }

    public List<DataSegmentAndIndexZipFilePath> getPublishedSegmentAndIndexZipFilePaths() {
        if (this.publishedSegmentAndIndexZipFilePaths == null) {
            throw new IllegalStateException("Job hasn't run yet. No segments have been published yet.");
        }
        return this.publishedSegmentAndIndexZipFilePaths;
    }

    public void setHadoopJobIdFile(String hadoopJobIdFile) {
        this.hadoopJobIdFile = hadoopJobIdFile;
    }
}

