/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.collections;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.druid.collections.ResourceHolder;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.utils.CloseableUtils;

public class CloseableResourceHolder<T extends Closeable>
implements ResourceHolder<T> {
    private final AtomicReference<T> resource;

    CloseableResourceHolder(T resource) {
        this.resource = new AtomicReference<Closeable>((Closeable)Preconditions.checkNotNull(resource, (Object)"resource"));
    }

    @Override
    public T get() {
        Closeable retVal = (Closeable)this.resource.get();
        if (retVal == null) {
            throw new ISE("Already closed", new Object[0]);
        }
        return (T)retVal;
    }

    @Override
    public void close() {
        Closeable oldResource = this.resource.getAndSet(null);
        CloseableUtils.closeAndWrapExceptions(oldResource);
    }
}

