/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.collections.spatial;

import com.google.common.base.Preconditions;
import org.apache.druid.collections.spatial.Node;
import org.apache.druid.collections.spatial.Point;

public class RTreeUtils {
    public static double getEnclosingArea(Node a, Node b) {
        Preconditions.checkArgument((a.getNumDims() == b.getNumDims() ? 1 : 0) != 0);
        double[] minCoords = new double[a.getNumDims()];
        double[] maxCoords = new double[a.getNumDims()];
        for (int i = 0; i < minCoords.length; ++i) {
            minCoords[i] = Math.min(a.getMinCoordinates()[i], b.getMinCoordinates()[i]);
            maxCoords[i] = Math.max(a.getMaxCoordinates()[i], b.getMaxCoordinates()[i]);
        }
        double area = 1.0;
        for (int i = 0; i < minCoords.length; ++i) {
            area *= maxCoords[i] - minCoords[i];
        }
        return area;
    }

    public static double getExpansionCost(Node node, Point point) {
        Preconditions.checkArgument((node.getNumDims() == point.getNumDims() ? 1 : 0) != 0);
        if (node.contains(point.getCoords())) {
            return 0.0;
        }
        double expanded = 1.0;
        for (int i = 0; i < node.getNumDims(); ++i) {
            double min = Math.min(point.getCoords()[i], node.getMinCoordinates()[i]);
            double max = Math.max(point.getCoords()[i], node.getMinCoordinates()[i]);
            expanded *= max - min;
        }
        return expanded - node.getArea();
    }

    public static void enclose(Node[] nodes) {
        for (Node node : nodes) {
            node.enclose();
        }
    }

    public static double calculateHaversineDistance(double lat1, double lon1, double lat2, double lon2) {
        double radLat1 = Math.toRadians(lat1);
        double radLon1 = Math.toRadians(lon1);
        double radLat2 = Math.toRadians(lat2);
        double radLon2 = Math.toRadians(lon2);
        double dLat = radLat2 - radLat1;
        double dLon = radLon2 - radLon1;
        double a = Math.sin(dLat / 2.0) * Math.sin(dLat / 2.0) + Math.cos(radLat1) * Math.cos(radLat2) * Math.sin(dLon / 2.0) * Math.sin(dLon / 2.0);
        double c = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
        double radius = 6371000.0;
        return radius * c;
    }
}

