/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input;

import java.util.function.Function;
import java.util.function.ToLongFunction;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.ListBasedInputRow;
import org.apache.druid.data.input.Row;
import org.apache.druid.segment.RowAdapter;
import org.apache.druid.segment.column.RowSignature;

public class ListBasedInputRowAdapter
implements RowAdapter<InputRow> {
    private final RowSignature fields;

    public ListBasedInputRowAdapter(RowSignature fields) {
        this.fields = fields;
    }

    @Override
    public ToLongFunction<InputRow> timestampFunction() {
        return Row::getTimestampFromEpoch;
    }

    @Override
    public Function<InputRow, Object> columnFunction(String columnName) {
        int i = this.fields.indexOf(columnName);
        if (i < 0) {
            return row -> null;
        }
        return row -> ((ListBasedInputRow)row).getRaw(i);
    }
}

