/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.common;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;

public class Cleaners {
    private static final Cleaner CLEANER;
    private static final RuntimeException CLEANER_NOT_SUPPORTED_EXCEPTION;

    private static Cleaner takeMeToTheCleaners() {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            return Cleaners.lookupCleaner(lookup);
        }
        catch (ReflectiveOperationException | RuntimeException e) {
            throw new UnsupportedOperationException("Cleaning is not support on this platform, because internal Java APIs are not compatible with this Druid version", e);
        }
    }

    private static Cleaner lookupCleaner(MethodHandles.Lookup lookup) throws ReflectiveOperationException {
        Object theCleaner;
        Class<?> cleaner = Class.forName("java.lang.ref.Cleaner");
        Class<?> cleanable = Class.forName("java.lang.ref.Cleaner$Cleanable");
        MethodHandle create = lookup.findStatic(cleaner, "create", MethodType.methodType(cleaner));
        try {
            theCleaner = create.invoke();
        }
        catch (Throwable t) {
            throw new RuntimeException("Unable to create cleaner", t);
        }
        MethodHandle register = lookup.findVirtual(cleaner, "register", MethodType.methodType(cleanable, Object.class, Runnable.class)).bindTo(theCleaner);
        MethodHandle clean = lookup.findVirtual(cleanable, "clean", MethodType.methodType(Void.TYPE));
        return new CleanerImpl(register, clean);
    }

    public static Cleanable register(Object object, Runnable runnable) {
        if (CLEANER == null) {
            throw new UnsupportedOperationException(CLEANER_NOT_SUPPORTED_EXCEPTION);
        }
        return CLEANER.register(object, runnable);
    }

    static {
        Cleaner cleaner = null;
        RuntimeException exception = null;
        try {
            cleaner = Cleaners.takeMeToTheCleaners();
        }
        catch (RuntimeException e) {
            exception = e;
        }
        if (cleaner != null) {
            CLEANER = cleaner;
            CLEANER_NOT_SUPPORTED_EXCEPTION = null;
        } else {
            CLEANER = null;
            CLEANER_NOT_SUPPORTED_EXCEPTION = exception;
        }
    }

    public static interface Cleaner {
        public Cleanable register(Object var1, Runnable var2);
    }

    private static class CleanerImpl
    implements Cleaner {
        private final MethodHandle register;
        private final MethodHandle clean;

        private CleanerImpl(MethodHandle register, MethodHandle clean) {
            this.register = register;
            this.clean = clean;
        }

        @Override
        public Cleanable register(Object object, Runnable runnable) {
            try {
                Object cleanable = this.register.invoke(object, runnable);
                return CleanerImpl.createCleanable(this.clean, cleanable);
            }
            catch (Throwable t) {
                throw new RuntimeException("Unable to register cleaning action", t);
            }
        }

        private static Cleanable createCleanable(MethodHandle clean, Object cleanable) {
            return () -> {
                try {
                    clean.invoke(cleanable);
                }
                catch (Throwable t) {
                    throw new RuntimeException("Unable to run cleaning action", t);
                }
            };
        }
    }

    public static interface Cleanable {
        public void clean();
    }
}

