/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.http.client.response;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.druid.java.util.http.client.response.FullResponseHolder;
import org.jboss.netty.handler.codec.http.HttpResponse;

public class BytesFullResponseHolder
extends FullResponseHolder<byte[]> {
    private final List<byte[]> chunks = new ArrayList<byte[]>();

    public BytesFullResponseHolder(HttpResponse response) {
        super(response);
    }

    public BytesFullResponseHolder addChunk(byte[] chunk) {
        this.chunks.add(chunk);
        return this;
    }

    @Override
    public byte[] getContent() {
        int size = 0;
        for (byte[] chunk : this.chunks) {
            size += chunk.length;
        }
        ByteBuffer buf = ByteBuffer.wrap(new byte[size]);
        for (byte[] chunk : this.chunks) {
            buf.put(chunk);
        }
        return buf.array();
    }

    public <T> T deserialize(ObjectMapper jsonMapper, TypeReference<T> typeReference) {
        try {
            return (T)jsonMapper.readValue(this.getContent(), typeReference);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

