/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.metrics;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.metrics.Monitor;

public abstract class CompoundMonitor
implements Monitor {
    private final List<Monitor> monitors;

    public CompoundMonitor(List<Monitor> monitors) {
        this.monitors = monitors;
    }

    public CompoundMonitor(Monitor ... monitors) {
        this(Arrays.asList(monitors));
    }

    @Override
    public void start() {
        for (Monitor monitor : this.monitors) {
            monitor.start();
        }
    }

    @Override
    public void stop() {
        for (Monitor monitor : this.monitors) {
            monitor.stop();
        }
    }

    @Override
    public boolean monitor(ServiceEmitter emitter) {
        return this.shouldReschedule(Lists.transform(this.monitors, monitor -> monitor.monitor(emitter)));
    }

    public abstract boolean shouldReschedule(List<Boolean> var1);
}

